/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.common;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpRedirectValidator {
    @Generated
    private static final Logger log = LogManager.getLogger(HttpRedirectValidator.class);
    private static final int HTTP_REDIRECT_STATUS_MIN = 300;
    private static final int HTTP_REDIRECT_STATUS_MAX = 400;
    private static final String LOCATION_HEADER = "Location";

    private HttpRedirectValidator() {
    }

    public static void validateNoRedirects(HttpURLConnection httpConnection) throws IOException {
        httpConnection.setInstanceFollowRedirects(false);
        int responseCode = httpConnection.getResponseCode();
        if (responseCode >= 300 && responseCode < 400) {
            String redirectLocation = httpConnection.getHeaderField(LOCATION_HEADER);
            throw new IllegalArgumentException(String.format(Locale.ROOT, "HTTP redirects are not allowed. URL [%s] attempted to redirect to [%s] with status code [%d]", httpConnection.getURL().toString(), redirectLocation != null ? redirectLocation : "unknown", responseCode));
        }
    }
}

