"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiKeyboardAccessible = void 0;
var _react = require("react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */ /**
 * Interactive elements must be able to receive focus.
 *
 * Ideally, this means using elements that are natively keyboard accessible (<a href="">,
 * <input type="button">, or <button>). Note that links should be used when navigating and buttons
 * should be used when performing an action on the page.
 *
 * If, however, you need to use elements that aren't natively keyboard accessible (for example, <div>,
 * <p>, or <a> without the href attribute), then you need to allow them to receive focus and to
 * respond to keyboard input. The workaround is to:
 *
 *   - Give the element tabindex="0" so that it can receive keyboard focus.
 *   - Add a JavaScript onkeyup event handler that triggers element functionality if the Enter key
 *     is pressed while the element is focused. This is necessary because some browsers do not trigger
 *    onclick events for such elements when activated via the keyboard.
 *   - If the item is meant to function as a button, the onkeyup event handler should also detect the
 *     Space bar in addition to the Enter key, and the element should be given role="button".
 *
 * Wrap any such elements that aren't natively keyboard accessible in this component to automatically
 * apply the above workaround to them.
 */
var EuiKeyboardAccessible = /*#__PURE__*/function (_Component) {
  _inherits(EuiKeyboardAccessible, _Component);
  var _super = _createSuper(EuiKeyboardAccessible);
  function EuiKeyboardAccessible() {
    var _this;
    _classCallCheck(this, EuiKeyboardAccessible);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (event) {
      // Prevent a scroll from occurring if the user has hit space.
      if (event.key === _services.keys.SPACE) {
        event.preventDefault();
      }
      if (_this.props.children.props.onKeyDown) {
        _this.props.children.props.onKeyDown(event);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onKeyUp", function (event) {
      // Support keyboard accessibility by emulating mouse click on ENTER or SPACE keypress.
      if (event.key === _services.keys.ENTER || event.key === _services.keys.SPACE) {
        // Delegate to the click handler on the element.
        _this.props.children.props.onClick(event);
      }
      if (_this.props.children.props.onKeyUp) {
        _this.props.children.props.onKeyUp(event);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "applyKeyboardAccessibility", function (child) {
      // Add attributes required for accessibility unless they are already specified.
      var props = _objectSpread(_objectSpread({
        tabIndex: '0',
        role: 'button'
      }, child.props), {}, {
        onKeyDown: _this.onKeyDown,
        onKeyUp: _this.onKeyUp
      });
      return /*#__PURE__*/(0, _react.cloneElement)(child, props);
    });
    return _this;
  }
  _createClass(EuiKeyboardAccessible, [{
    key: "render",
    value: function render() {
      return this.applyKeyboardAccessibility(this.props.children);
    }
  }]);
  return EuiKeyboardAccessible;
}(_react.Component); // @ts-ignore defining this as a static on EuiKeyboardAccessible breaks the
// tests
exports.EuiKeyboardAccessible = EuiKeyboardAccessible;
EuiKeyboardAccessible.propTypes = {
  /**
     * ReactNode to render as this component's children
     */
  children: _propTypes.default.element.isRequired
};
EuiKeyboardAccessible.propTypes = {
  children: keyboardInaccessibleElement
};
function keyboardInaccessibleElement(props, propName, componentName) {
  var child = props.children;
  if (!child) {
    throw new Error("".concat(componentName, " needs to wrap an element with which the user interacts."));
  }

  // The whole point of this component is to hack in functionality that native buttons provide
  // by default.
  if (child.type === 'button') {
    throw new Error("".concat(componentName, " doesn't need to be used on a button."));
  }
  if (child.type === 'a' && child.props.href !== undefined) {
    throw new Error("".concat(componentName, " doesn't need to be used on a link if it has a href attribute."));
  }

  // We're emulating a click action, so we should already have a regular click handler defined.
  if (!child.props.onClick) {
    throw new Error("".concat(componentName, " needs to wrap an element which has an onClick prop assigned."));
  }
  if (typeof child.props.onClick !== 'function') {
    throw new Error("".concat(componentName, "'s child's onClick prop needs to be a function."));
  }
}