/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.Schedule;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\n\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,H\u0016J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u00103\u001a\u00020 2\b\u00104\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u00105\u001a\u00020\u0003H\u00d6\u0001J\t\u00106\u001a\u00020-H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/opensearch/commons/alerting/model/IntervalSchedule;", "Lorg/opensearch/commons/alerting/model/Schedule;", "interval", "", "unit", "Ljava/time/temporal/ChronoUnit;", "testInstant", "Ljava/time/Instant;", "<init>", "(ILjava/time/temporal/ChronoUnit;Ljava/time/Instant;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getInterval", "()I", "getUnit", "()Ljava/time/temporal/ChronoUnit;", "getTestInstant", "()Ljava/time/Instant;", "intervalInMills", "", "nextTimeToExecute", "Ljava/time/Duration;", "enabledTime", "getExpectedNextExecutionTime", "expectedPreviousExecutionTime", "getPeriodStartingAt", "Lkotlin/Pair;", "startTime", "getPeriodEndingAt", "endTime", "runningOnTime", "", "lastExecutionTime", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "asTemplateArg", "", "", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "Companion", "common-utils"})
public final class IntervalSchedule
extends Schedule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int interval;
    @NotNull
    private final ChronoUnit unit;
    @Nullable
    private final transient Instant testInstant;
    private final transient long intervalInMills;
    @NotNull
    private static final transient List<ChronoUnit> SUPPORTED_UNIT;

    public IntervalSchedule(int interval, @NotNull ChronoUnit unit, @Nullable Instant testInstant) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        super(null);
        this.interval = interval;
        this.unit = unit;
        this.testInstant = testInstant;
        if (!SUPPORTED_UNIT.contains(this.unit)) {
            throw new IllegalArgumentException("Timezone " + this.unit + " is not supported expected " + SUPPORTED_UNIT);
        }
        if (this.interval <= 0) {
            throw new IllegalArgumentException("Interval is not allowed to be 0 or negative");
        }
        this.intervalInMills = Duration.of(this.interval, this.unit).toMillis();
    }

    public /* synthetic */ IntervalSchedule(int n, ChronoUnit chronoUnit, Instant instant, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            instant = null;
        }
        this(n, chronoUnit, instant);
    }

    public final int getInterval() {
        return this.interval;
    }

    @NotNull
    public final ChronoUnit getUnit() {
        return this.unit;
    }

    @Nullable
    public final Instant getTestInstant() {
        return this.testInstant;
    }

    public IntervalSchedule(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        int n = sin.readInt();
        Enum enum_ = sin.readEnum(ChronoUnit.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        this(n, (ChronoUnit)enum_, null, 4, null);
    }

    @Override
    @Nullable
    public Duration nextTimeToExecute(@NotNull Instant enabledTime) {
        Intrinsics.checkNotNullParameter((Object)enabledTime, (String)"enabledTime");
        long enabledTimeEpochMillis = enabledTime.toEpochMilli();
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant currentTime = instant;
        long delta = currentTime.toEpochMilli() - enabledTimeEpochMillis;
        long remainingScheduleTime = this.intervalInMills - delta % this.intervalInMills;
        return Duration.of(remainingScheduleTime, ChronoUnit.MILLIS);
    }

    @Override
    @Nullable
    public Instant getExpectedNextExecutionTime(@NotNull Instant enabledTime, @Nullable Instant expectedPreviousExecutionTime) {
        Intrinsics.checkNotNullParameter((Object)enabledTime, (String)"enabledTime");
        Instant instant = expectedPreviousExecutionTime;
        if (instant == null) {
            instant = enabledTime;
        }
        long expectedPreviousExecutionTimeEpochMillis = instant.toEpochMilli();
        Instant instant2 = this.testInstant;
        if (instant2 == null) {
            instant2 = Instant.now();
        }
        Instant currentTime = instant2;
        long delta = currentTime.toEpochMilli() - expectedPreviousExecutionTimeEpochMillis;
        long remainingScheduleTime = this.intervalInMills - delta % this.intervalInMills;
        return Instant.ofEpochMilli(currentTime.toEpochMilli() + remainingScheduleTime);
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodStartingAt(@Nullable Instant startTime) {
        Instant instant = startTime;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant realStartTime = instant;
        Instant newEndTime = realStartTime.plusMillis(this.intervalInMills);
        return new Pair((Object)realStartTime, (Object)newEndTime);
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodEndingAt(@Nullable Instant endTime) {
        Instant instant = endTime;
        if (instant == null) {
            instant = Instant.now();
        }
        Instant realEndTime = instant;
        Instant newStartTime = realEndTime.minusMillis(this.intervalInMills);
        return new Pair((Object)newStartTime, (Object)realEndTime);
    }

    @Override
    public boolean runningOnTime(@Nullable Instant lastExecutionTime) {
        long delta;
        if (lastExecutionTime == null) {
            return true;
        }
        Temporal temporal = lastExecutionTime;
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        return 0L < (delta = ChronoUnit.MILLIS.between(temporal, instant)) && delta < this.intervalInMills;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().startObject("period").field("interval", this.interval).field("unit", this.unit.name()).endObject().endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.interval);
        out.writeEnum((Enum)this.unit);
    }

    @Override
    @NotNull
    public Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"interval", (Object)this.interval), TuplesKt.to((Object)"unit", (Object)this.unit.toString())};
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"period", (Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    public final int component1() {
        return this.interval;
    }

    @NotNull
    public final ChronoUnit component2() {
        return this.unit;
    }

    @Nullable
    public final Instant component3() {
        return this.testInstant;
    }

    @NotNull
    public final IntervalSchedule copy(int interval, @NotNull ChronoUnit unit, @Nullable Instant testInstant) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return new IntervalSchedule(interval, unit, testInstant);
    }

    public static /* synthetic */ IntervalSchedule copy$default(IntervalSchedule intervalSchedule, int n, ChronoUnit chronoUnit, Instant instant, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = intervalSchedule.interval;
        }
        if ((n2 & 2) != 0) {
            chronoUnit = intervalSchedule.unit;
        }
        if ((n2 & 4) != 0) {
            instant = intervalSchedule.testInstant;
        }
        return intervalSchedule.copy(n, chronoUnit, instant);
    }

    @NotNull
    public String toString() {
        return "IntervalSchedule(interval=" + this.interval + ", unit=" + this.unit + ", testInstant=" + this.testInstant + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.interval);
        result = result * 31 + this.unit.hashCode();
        result = result * 31 + (this.testInstant == null ? 0 : this.testInstant.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntervalSchedule)) {
            return false;
        }
        IntervalSchedule intervalSchedule = (IntervalSchedule)other;
        if (this.interval != intervalSchedule.interval) {
            return false;
        }
        if (this.unit != intervalSchedule.unit) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.testInstant, (Object)intervalSchedule.testInstant);
    }

    @JvmStatic
    @NotNull
    public static final IntervalSchedule readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    static {
        Object[] objectArray = new ChronoUnit[]{ChronoUnit.SECONDS, ChronoUnit.MINUTES, ChronoUnit.HOURS, ChronoUnit.DAYS};
        SUPPORTED_UNIT = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/commons/alerting/model/IntervalSchedule$Companion;", "", "<init>", "()V", "SUPPORTED_UNIT", "", "Ljava/time/temporal/ChronoUnit;", "readFrom", "Lorg/opensearch/commons/alerting/model/IntervalSchedule;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntervalSchedule readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new IntervalSchedule(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

