/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.scale.searchonly;

import java.io.IOException;
import java.util.List;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.transport.TransportRequest;

class ScaleIndexNodeRequest
extends TransportRequest {
    private final String index;
    private final List<ShardId> shardIds;

    ScaleIndexNodeRequest(String index, List<ShardId> shardIds) {
        this.index = index;
        this.shardIds = shardIds;
    }

    ScaleIndexNodeRequest(StreamInput in) throws IOException {
        super(in);
        this.index = in.readString();
        this.shardIds = in.readList(ShardId::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeList(this.shardIds);
    }

    String getIndex() {
        return this.index;
    }

    List<ShardId> getShardIds() {
        return this.shardIds;
    }
}

