/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.sco;

import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.DesignSpace;
import net.adaptivebox.space.ILocationEngine;

public class SCAgent {
    private ProblemEncoder problemEncoder;
    private IGoodnessCompareEngine specComparator;
    private static final int TaoB = 2;
    private static final int TaoW = 4;
    private Library externalLib;
    private SearchPoint trailPoint;
    private SearchPoint pcurrent_t;

    public void setExternalLib(Library library) {
        this.externalLib = library;
    }

    public void setProblemEncoder(ProblemEncoder problemEncoder) {
        this.problemEncoder = problemEncoder;
        this.trailPoint = this.problemEncoder.getFreshSearchPoint();
        this.pcurrent_t = this.problemEncoder.getEncodedSearchPoint();
    }

    public void setSpecComparator(IGoodnessCompareEngine iGoodnessCompareEngine) {
        this.specComparator = iGoodnessCompareEngine;
    }

    public SearchPoint generatePoint() {
        this.generatePoint(this.trailPoint);
        this.problemEncoder.evaluate(this.trailPoint);
        return this.trailPoint;
    }

    private void generatePoint(ILocationEngine iLocationEngine) {
        SearchPoint searchPoint;
        SearchPoint searchPoint2;
        int n = this.externalLib.tournamentSelection(this.specComparator, 2, true);
        SearchPoint searchPoint3 = this.externalLib.getSelectedPoint(n);
        if (this.specComparator.compare(this.pcurrent_t.getEncodeInfo(), searchPoint3.getEncodeInfo()) == 2) {
            searchPoint2 = searchPoint3;
            searchPoint = this.pcurrent_t;
        } else {
            searchPoint2 = this.pcurrent_t;
            searchPoint = searchPoint3;
        }
        this.inferPoint(iLocationEngine, searchPoint2, searchPoint, this.problemEncoder.getDesignSpace());
    }

    public void updateInfo() {
        int n = this.externalLib.tournamentSelection(this.specComparator, 4, false);
        this.externalLib.getSelectedPoint(n).importPoint(this.pcurrent_t);
        this.pcurrent_t.importPoint(this.trailPoint);
    }

    private boolean inferPoint(ILocationEngine iLocationEngine, ILocationEngine iLocationEngine2, ILocationEngine iLocationEngine3, DesignSpace designSpace) {
        double[] dArray = iLocationEngine.getLocation();
        double[] dArray2 = iLocationEngine2.getLocation();
        double[] dArray3 = iLocationEngine3.getLocation();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray2[i] * 2.0 - dArray3[i];
            dArray[i] = designSpace.boundAdjustAt(dArray[i], i);
            dArray[i] = RandomGenerator.doubleRangeRandom(dArray[i], dArray3[i]);
        }
        return true;
    }
}

