/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.DefaultDiagnosticReporter;
import org.jetbrains.kotlin.cli.common.messages.DiagnosticMessageReporter;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.GenericDiagnostics;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.fir.builder.FirSyntaxErrors;
import org.jetbrains.kotlin.load.java.components.TraceBasedErrorReporter;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0003\"#$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0016\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u0007H\u0016J$\u0010\u001f\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport;", "Lorg/jetbrains/kotlin/analyzer/AbstractAnalyzerWithCompilerReport;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "renderDiagnosticName", "", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Z)V", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "targetEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "getTargetEnvironment", "()Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "analysisResult", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "getAnalysisResult", "()Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "setAnalysisResult", "(Lorg/jetbrains/kotlin/analyzer/AnalysisResult;)V", "reportIncompleteHierarchies", "", "reportAlternativeSignatureErrors", "reportSyntaxErrors", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "hasErrors", "analyzeAndReport", "analyze", "Lkotlin/Function0;", "SyntaxErrorReport", "MyDiagnostic", "Companion", "cli"})
public final class AnalyzerWithCompilerReport
implements AbstractAnalyzerWithCompilerReport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final boolean renderDiagnosticName;
    public AnalysisResult analysisResult;
    @NotNull
    private static final DiagnosticFactory0<PsiErrorElement> SYNTAX_ERROR_FACTORY;

    public AnalyzerWithCompilerReport(@NotNull MessageCollector messageCollector, @NotNull LanguageVersionSettings languageVersionSettings, boolean renderDiagnosticName) {
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.messageCollector = messageCollector;
        this.languageVersionSettings = languageVersionSettings;
        this.renderDiagnosticName = renderDiagnosticName;
    }

    @Override
    @NotNull
    public TargetEnvironment getTargetEnvironment() {
        return CompilerEnvironment.INSTANCE;
    }

    @Override
    @NotNull
    public AnalysisResult getAnalysisResult() {
        AnalysisResult analysisResult = this.analysisResult;
        if (analysisResult != null) {
            return analysisResult;
        }
        Intrinsics.throwUninitializedPropertyAccessException("analysisResult");
        return null;
    }

    public void setAnalysisResult(@NotNull AnalysisResult analysisResult) {
        Intrinsics.checkNotNullParameter(analysisResult, "<set-?>");
        this.analysisResult = analysisResult;
    }

    public AnalyzerWithCompilerReport(@NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        this(CommonConfigurationKeysKt.getMessageCollector(configuration2), CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2), configuration2.getBoolean(CLIConfigurationKeys.RENDER_DIAGNOSTIC_INTERNAL_NAME));
    }

    private final void reportIncompleteHierarchies() {
        BindingContext bindingContext = this.getAnalysisResult().getBindingContext();
        Collection<ClassDescriptor> collection = bindingContext.getKeys(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY);
        Intrinsics.checkNotNullExpressionValue(collection, "getKeys(...)");
        Collection<ClassDescriptor> classes = collection;
        if (!classes.isEmpty()) {
            StringBuilder message2 = new StringBuilder("Supertypes of the following classes cannot be resolved. Please make sure you have the required dependencies in the classpath:\n");
            for (ClassDescriptor descriptor : classes) {
                boolean bl;
                String fqName = DescriptorUtils.getFqName(descriptor).asString();
                List unresolved = (List)bindingContext.get(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY, descriptor);
                boolean bl2 = bl = unresolved != null && !unresolved.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Incomplete hierarchy should be reported with names of unresolved superclasses: " + fqName;
                    throw new AssertionError((Object)string);
                }
                StringBuilder stringBuilder = message2.append("    class ").append(fqName).append(", unresolved supertypes: ");
                List list = unresolved;
                Intrinsics.checkNotNull(list);
                stringBuilder.append(CollectionsKt.joinToString$default(list, null, null, null, 0, null, null, 63, null)).append("\n");
            }
            String string = message2.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            MessageCollector.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
        }
    }

    private final void reportAlternativeSignatureErrors() {
        BindingContext bc2 = this.getAnalysisResult().getBindingContext();
        Collection<DeclarationDescriptor> collection = bc2.getKeys(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS);
        Intrinsics.checkNotNullExpressionValue(collection, "getKeys(...)");
        Collection<DeclarationDescriptor> descriptorsWithErrors = collection;
        if (!descriptorsWithErrors.isEmpty()) {
            StringBuilder message2 = new StringBuilder("The following Java entities have annotations with wrong Kotlin signatures:\n");
            for (DeclarationDescriptor descriptor : descriptorsWithErrors) {
                boolean bl;
                Intrinsics.checkNotNull(descriptor);
                PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
                boolean bl2 = declaration instanceof PsiModifierListOwner;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                List errors = (List)bc2.get(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor);
                boolean bl3 = bl = errors != null && !errors.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                Intrinsics.checkNotNull(declaration, "null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)declaration);
                message2.append(externalName).append(":\n");
                List list = errors;
                Intrinsics.checkNotNull(list);
                for (String error : list) {
                    message2.append("    ").append(error).append("\n");
                }
            }
            String string = message2.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            MessageCollector.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
        }
    }

    private final void reportSyntaxErrors(Collection<? extends KtFile> files2) {
        for (KtFile ktFile : files2) {
            Companion.reportSyntaxErrors((PsiElement)ktFile, this.messageCollector);
        }
    }

    @Override
    public boolean hasErrors() {
        return this.messageCollector.hasErrors();
    }

    @Override
    public void analyzeAndReport(@NotNull Collection<? extends KtFile> files2, @NotNull Function0<? extends AnalysisResult> analyze2) {
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(analyze2, "analyze");
        this.setAnalysisResult(analyze2.invoke());
        if (!this.getAnalysisResult().isError()) {
            OptInUsageChecker.Companion.checkCompilerArguments(this.getAnalysisResult().getModuleDescriptor(), this.languageVersionSettings, arg_0 -> AnalyzerWithCompilerReport.analyzeAndReport$lambda$0(this, arg_0), arg_0 -> AnalyzerWithCompilerReport.analyzeAndReport$lambda$1(this, arg_0));
        }
        this.reportSyntaxErrors(files2);
        Diagnostics diagnostics = this.getAnalysisResult().getBindingContext().getDiagnostics();
        Intrinsics.checkNotNullExpressionValue(diagnostics, "getDiagnostics(...)");
        Companion.reportDiagnostics((GenericDiagnostics)diagnostics, this.messageCollector, this.renderDiagnosticName);
        this.reportIncompleteHierarchies();
        this.reportAlternativeSignatureErrors();
    }

    private static final Unit analyzeAndReport$lambda$0(AnalyzerWithCompilerReport this$0, String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        MessageCollector.report$default(this$0.messageCollector, CompilerMessageSeverity.ERROR, message2, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit analyzeAndReport$lambda$1(AnalyzerWithCompilerReport this$0, String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        MessageCollector.report$default(this$0.messageCollector, CompilerMessageSeverity.WARNING, message2, null, 4, null);
        return Unit.INSTANCE;
    }

    static {
        DiagnosticFactory0 diagnosticFactory0 = DiagnosticFactory0.create(Severity.ERROR);
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, "create(...)");
        SYNTAX_ERROR_FACTORY = diagnosticFactory0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002J\"\u0010\u0013\u001a\u00020\r2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\"\u0010\u0013\u001a\u00020\r2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rJ&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J9\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2'\u0010%\u001a#\u0012\u0004\u0012\u00020\n\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u001b0&H\u0002J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion;", "", "<init>", "()V", "convertSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "SYNTAX_ERROR_FACTORY", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lcom/intellij/psi/PsiErrorElement;", "kotlin.jvm.PlatformType", "reportDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "reporter", "Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;", "renderDiagnosticName", "reportDiagnostics", "unsortedDiagnostics", "Lorg/jetbrains/kotlin/diagnostics/GenericDiagnostics;", "diagnostics", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "renderInternalDiagnosticName", "reportSpecialErrors", "", "hasIncompatibleClasses", "hasPrereleaseClasses", "hasUnstableClasses", "reportSyntaxErrors", "Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "file", "Lcom/intellij/psi/PsiElement;", "diagnosticCollector", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "createAndReportSyntaxError", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "message", "cli"})
    @SourceDebugExtension(value={"SMAP\nAnalyzerWithCompilerReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzerWithCompilerReport.kt\norg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,296:1\n808#2,11:297\n1761#2,3:308\n1761#2,3:311\n1761#2,3:314\n*S KotlinDebug\n*F\n+ 1 AnalyzerWithCompilerReport.kt\norg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion\n*L\n168#1:297,11\n182#1:308,3\n183#1:311,3\n184#1:314,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompilerMessageSeverity convertSeverity(@NotNull Severity severity) {
            CompilerMessageSeverity compilerMessageSeverity;
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    compilerMessageSeverity = CompilerMessageSeverity.INFO;
                    break;
                }
                case 2: {
                    compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                    break;
                }
                case 3: {
                    compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                    break;
                }
                case 4: {
                    compilerMessageSeverity = CompilerMessageSeverity.FIXED_WARNING;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return compilerMessageSeverity;
        }

        private final boolean reportDiagnostic(Diagnostic diagnostic, DiagnosticMessageReporter reporter, boolean renderDiagnosticName) {
            Object object;
            if (!diagnostic.isValid()) {
                return false;
            }
            Object object2 = diagnostic instanceof MyDiagnostic ? (MyDiagnostic)diagnostic : null;
            if (object2 == null || (object2 = ((MyDiagnostic)object2).getMessage()) == null) {
                String string = DefaultErrorMessages.render(diagnostic);
                object2 = string;
                Intrinsics.checkNotNullExpressionValue(string, "render(...)");
            }
            Object message2 = object2;
            boolean bl = renderDiagnosticName;
            if (bl) {
                object = '[' + diagnostic.getFactoryName() + "] " + (String)message2;
            } else if (!bl) {
                object = message2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Object textToRender = object;
            reporter.report(diagnostic, diagnostic.getPsiFile(), (String)textToRender);
            return diagnostic.getSeverity() == Severity.ERROR;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean reportDiagnostics(@NotNull GenericDiagnostics<?> unsortedDiagnostics, @NotNull DiagnosticMessageReporter reporter, boolean renderDiagnosticName) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(unsortedDiagnostics, "unsortedDiagnostics");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            boolean hasErrors = false;
            Iterable $this$filterIsInstance$iv = unsortedDiagnostics.all();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Diagnostic)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<Diagnostic> list = DiagnosticUtils.sortedDiagnostics((List)destination$iv$iv);
            Intrinsics.checkNotNullExpressionValue(list, "sortedDiagnostics(...)");
            List<Diagnostic> diagnostics = list;
            for (Diagnostic diagnostic : diagnostics) {
                Intrinsics.checkNotNull(diagnostic);
                hasErrors |= this.reportDiagnostic(diagnostic, reporter, renderDiagnosticName);
            }
            return hasErrors;
        }

        public final boolean reportDiagnostics(@NotNull GenericDiagnostics<?> diagnostics, @NotNull MessageCollector messageCollector, boolean renderInternalDiagnosticName) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Companion companion;
            boolean bl4;
            block11: {
                boolean bl5;
                UnboundDiagnostic it;
                Iterable $this$any$iv;
                boolean $i$f$any;
                block10: {
                    boolean bl6;
                    block9: {
                        Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
                        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
                        boolean it2 = bl4 = this.reportDiagnostics(diagnostics, new DefaultDiagnosticReporter(messageCollector), renderInternalDiagnosticName);
                        boolean bl7 = false;
                        Iterable iterable = diagnostics;
                        companion = Companion;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl6 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (UnboundDiagnostic)element$iv;
                                boolean bl8 = false;
                                if (!Intrinsics.areEqual(it.getFactory(), Errors.INCOMPATIBLE_CLASS)) continue;
                                bl6 = true;
                                break block9;
                            }
                            bl6 = false;
                        }
                    }
                    bl3 = bl6;
                    $this$any$iv = diagnostics;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (UnboundDiagnostic)element$iv;
                            boolean bl9 = false;
                            if (!Intrinsics.areEqual(it.getFactory(), Errors.PRE_RELEASE_CLASS)) continue;
                            bl5 = true;
                            break block10;
                        }
                        bl5 = false;
                    }
                }
                bl2 = bl5;
                $this$any$iv = diagnostics;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (UnboundDiagnostic)element$iv;
                        boolean bl10 = false;
                        if (!Intrinsics.areEqual(it.getFactory(), Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            boolean bl11 = bl;
            companion.reportSpecialErrors(bl3, bl2, bl11, messageCollector);
            return bl4;
        }

        public final void reportSpecialErrors(boolean hasIncompatibleClasses, boolean hasPrereleaseClasses, boolean hasUnstableClasses, @NotNull MessageCollector messageCollector) {
            Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
            if (hasIncompatibleClasses) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Incompatible classes were found in dependencies. Remove them from the classpath or use '-Xskip-metadata-version-check' to suppress errors", null, 4, null);
            }
            if (hasPrereleaseClasses) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Pre-release declarations were found in dependencies. Please exclude the dependencies with such declarations and recompile with a release compiler, or use '-Xskip-prerelease-check' to suppress errors. Note that in the latter case the compiled declarations will also be marked as pre-release.", null, 4, null);
            }
            if (hasUnstableClasses) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Classes compiled by an unstable version of the Kotlin compiler were found in dependencies. Remove them from the classpath or use '-Xallow-unstable-dependencies' to suppress errors", null, 4, null);
            }
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file, @NotNull DiagnosticMessageReporter reporter) {
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            return this.reportSyntaxErrors(file, (arg_0, arg_1) -> Companion.reportSyntaxErrors$lambda$0(reporter, arg_0, arg_1));
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file, @NotNull BaseDiagnosticsCollector diagnosticCollector) {
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(diagnosticCollector, "diagnosticCollector");
            return this.reportSyntaxErrors(file, (arg_0, arg_1) -> Companion.reportSyntaxErrors$lambda$1(diagnosticCollector, file, arg_0, arg_1));
        }

        private final SyntaxErrorReport reportSyntaxErrors(PsiElement file, Function2<? super PsiErrorElement, ? super String, Unit> createAndReportSyntaxError) {
            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\r\u001a\u00020\u0005*\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0013"}, d2={"org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion$reportSyntaxErrors$ErrorReportingVisitor", "Lorg/jetbrains/kotlin/resolve/AnalyzingUtils$PsiErrorElementVisitor;", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "hasErrors", "", "getHasErrors", "()Z", "setHasErrors", "(Z)V", "allErrorsAtEof", "getAllErrorsAtEof", "setAllErrorsAtEof", "isAtEof", "Lcom/intellij/psi/PsiElement;", "visitErrorElement", "", "element", "Lcom/intellij/psi/PsiErrorElement;", "cli"})
            public final class ErrorReportingVisitor
            extends AnalyzingUtils.PsiErrorElementVisitor {
                private boolean hasErrors;
                private boolean allErrorsAtEof;
                final /* synthetic */ Function2<PsiErrorElement, String, Unit> $createAndReportSyntaxError;

                public ErrorReportingVisitor(Function2<? super PsiErrorElement, ? super String, Unit> $createAndReportSyntaxError) {
                    this.$createAndReportSyntaxError = $createAndReportSyntaxError;
                    this.allErrorsAtEof = true;
                }

                public final boolean getHasErrors() {
                    return this.hasErrors;
                }

                public final void setHasErrors(boolean bl) {
                    this.hasErrors = bl;
                }

                public final boolean getAllErrorsAtEof() {
                    return this.allErrorsAtEof;
                }

                public final void setAllErrorsAtEof(boolean bl) {
                    this.allErrorsAtEof = bl;
                }

                private final boolean isAtEof(PsiElement $this$isAtEof) {
                    PsiElement element = $this$isAtEof;
                    do {
                        if (element.getNextSibling() != null) continue;
                        return true;
                    } while (element instanceof PsiWhiteSpace && element instanceof PsiComment);
                    return false;
                }

                public void visitErrorElement(PsiErrorElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    String string = element.getErrorDescription();
                    Intrinsics.checkNotNullExpressionValue(string, "getErrorDescription(...)");
                    String description = string;
                    if (this.allErrorsAtEof && !this.isAtEof(element)) {
                        this.allErrorsAtEof = false;
                    }
                    this.hasErrors = true;
                    this.$createAndReportSyntaxError.invoke(element, StringUtil.isEmpty(description) ? "Syntax error" : description);
                }
            }
            ErrorReportingVisitor visitor2 = new ErrorReportingVisitor(createAndReportSyntaxError);
            file.accept(visitor2);
            return new SyntaxErrorReport(visitor2.getHasErrors(), visitor2.getAllErrorsAtEof());
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file, @NotNull MessageCollector messageCollector) {
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
            return this.reportSyntaxErrors(file, new DefaultDiagnosticReporter(messageCollector));
        }

        private static final Unit reportSyntaxErrors$lambda$0(DiagnosticMessageReporter $reporter, PsiErrorElement element, String message2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(message2, "message");
            MyDiagnostic<PsiElement> diagnostic = new MyDiagnostic<PsiElement>((PsiElement)element, SYNTAX_ERROR_FACTORY, message2);
            Companion.reportDiagnostic(diagnostic, $reporter, false);
            return Unit.INSTANCE;
        }

        private static final Unit reportSyntaxErrors$lambda$1(BaseDiagnosticsCollector $diagnosticCollector, PsiElement $file, PsiErrorElement element, String message2) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(message2, "message");
            KtDiagnosticWithParameters1<String> diagnostic = FirSyntaxErrors.INSTANCE.getSYNTAX().on(new KtRealPsiSourceElement(element), message2, null, LanguageVersionSettingsImpl.DEFAULT);
            DiagnosticContext context2 = new DiagnosticContext($file){
                final /* synthetic */ PsiElement $file;
                {
                    this.$file = $file;
                }

                public String getContainingFilePath() {
                    VirtualFile virtualFile = this.$file.getContainingFile().getVirtualFile();
                    return virtualFile != null ? virtualFile.getPath() : null;
                }

                public boolean isDiagnosticSuppressed(KtDiagnostic diagnostic) {
                    Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
                    return false;
                }

                public LanguageVersionSettings getLanguageVersionSettings() {
                    return LanguageVersionSettingsImpl.DEFAULT;
                }
            };
            $diagnosticCollector.report(diagnostic, context2);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Severity.values().length];
                try {
                    nArray[Severity.INFO.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Severity.WARNING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Severity.FIXED_WARNING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$MyDiagnostic;", "E", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/diagnostics/SimpleDiagnostic;", "psiElement", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "message", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "isValid", "", "()Z", "cli"})
    private static final class MyDiagnostic<E extends PsiElement>
    extends SimpleDiagnostic<E> {
        @NotNull
        private final String message;
        private final boolean isValid;

        public MyDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactory0<E> factory, @NotNull String message2) {
            Intrinsics.checkNotNullParameter(psiElement, "psiElement");
            Intrinsics.checkNotNullParameter(factory, "factory");
            Intrinsics.checkNotNullParameter(message2, "message");
            super(psiElement, factory, Severity.ERROR);
            this.message = message2;
            this.isValid = true;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "", "isHasErrors", "", "isAllErrorsAtEof", "<init>", "(ZZ)V", "()Z", "cli"})
    public static final class SyntaxErrorReport {
        private final boolean isHasErrors;
        private final boolean isAllErrorsAtEof;

        public SyntaxErrorReport(boolean isHasErrors, boolean isAllErrorsAtEof) {
            this.isHasErrors = isHasErrors;
            this.isAllErrorsAtEof = isAllErrorsAtEof;
        }

        public final boolean isHasErrors() {
            return this.isHasErrors;
        }

        public final boolean isAllErrorsAtEof() {
            return this.isAllErrorsAtEof;
        }
    }
}

