/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.lang.runtime.ObjectMethods;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;
import org.hibernate.type.descriptor.jdbc.StructAttributeValues;
import org.hibernate.type.descriptor.jdbc.StructHelper;
import org.hibernate.type.format.JsonDocumentItemType;
import org.hibernate.type.format.JsonDocumentReader;
import org.hibernate.type.format.JsonValueJDBCTypeAdapter;
import org.hibernate.type.format.JsonValueJDBCTypeAdapterFactory;
import org.hibernate.type.format.StringJsonDocumentReader;

@Internal
public class JsonHelper {
    private static <X> X consumeJsonDocumentItems(JsonDocumentReader reader, EmbeddableMappingType embeddableMappingType, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        StandardStack<ParseLevel> parseLevel = new StandardStack<ParseLevel>();
        JsonValueJDBCTypeAdapter adapter = JsonValueJDBCTypeAdapterFactory.getAdapter(reader, returnEmbeddable);
        final class ParseLevel
        extends Record {
            private final @Nullable SelectableData selectableData;
            private final @Nullable EmbeddableMappingType embeddableMappingType;
            private final @Nullable BasicPluralType<?, ?> arrayType;
            private final @Nullable List<Object> subArrayObjectList;
            private final @Nullable Object[] objectArray;

            ParseLevel(EmbeddableMappingType embeddableMappingType) {
                record SelectableData(String selectableName, int selectableIndex, SelectableMapping selectableMapping) {
                }
                this(null, embeddableMappingType);
            }

            ParseLevel(@Nullable SelectableData selectableData, EmbeddableMappingType embeddableMappingType) {
                this(selectableData, embeddableMappingType, null, null, new Object[embeddableMappingType.getJdbcValueCount() + (embeddableMappingType.isPolymorphic() ? 1 : 0)]);
            }

            ParseLevel(@Nullable SelectableData selectableData, BasicPluralType<?, ?> arrayType) {
                this(selectableData, null, arrayType, new ArrayList<Object>(), null);
            }

            ParseLevel(@Nullable SelectableData selectableData, @Nullable EmbeddableMappingType embeddableMappingType, @Nullable BasicPluralType<?, ?> arrayType, @Nullable List<Object> subArrayObjectList, @Nullable Object[] objectArray) {
                this.selectableData = selectableData;
                this.embeddableMappingType = embeddableMappingType;
                this.arrayType = arrayType;
                this.subArrayObjectList = subArrayObjectList;
                this.objectArray = objectArray;
            }

            public void addValue(@Nullable SelectableData selectableData, @Nullable Object value) {
                if (this.embeddableMappingType != null) {
                    assert (selectableData != null);
                    this.objectArray[selectableData.selectableIndex] = value;
                } else {
                    assert (this.subArrayObjectList != null);
                    this.subArrayObjectList.add(value);
                }
            }

            public JdbcMapping determineJdbcMapping(@Nullable SelectableData currentSelectableData) {
                if (currentSelectableData != null) {
                    return currentSelectableData.selectableMapping.getJdbcMapping();
                }
                if (this.arrayType != null) {
                    return this.arrayType.getElementType();
                }
                assert (this.selectableData != null);
                return this.selectableData.selectableMapping.getJdbcMapping();
            }

            public static String determineSelectablePath(StandardStack<ParseLevel> parseLevel, @Nullable SelectableData currentSelectableData) {
                if (currentSelectableData != null) {
                    return currentSelectableData.selectableName;
                }
                return ParseLevel.determineSelectablePath(parseLevel, 0);
            }

            private static String determineSelectablePath(StandardStack<ParseLevel> stack, int level) {
                ParseLevel parseLevel = stack.peek(level);
                assert (parseLevel != null);
                if (parseLevel.selectableData != null) {
                    return parseLevel.selectableData.selectableName;
                }
                assert (parseLevel.arrayType != null);
                return ParseLevel.determineSelectablePath(stack, level + 1) + ".{element}";
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{ParseLevel.class, "selectableData;embeddableMappingType;arrayType;subArrayObjectList;objectArray", "selectableData", "embeddableMappingType", "arrayType", "subArrayObjectList", "objectArray"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ParseLevel.class, "selectableData;embeddableMappingType;arrayType;subArrayObjectList;objectArray", "selectableData", "embeddableMappingType", "arrayType", "subArrayObjectList", "objectArray"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ParseLevel.class, "selectableData;embeddableMappingType;arrayType;subArrayObjectList;objectArray", "selectableData", "embeddableMappingType", "arrayType", "subArrayObjectList", "objectArray"}, this, o);
            }

            public @Nullable SelectableData selectableData() {
                return this.selectableData;
            }

            public @Nullable EmbeddableMappingType embeddableMappingType() {
                return this.embeddableMappingType;
            }

            public @Nullable BasicPluralType<?, ?> arrayType() {
                return this.arrayType;
            }

            public @Nullable List<Object> subArrayObjectList() {
                return this.subArrayObjectList;
            }

            public @Nullable Object[] objectArray() {
                return this.objectArray;
            }
        }
        parseLevel.push(new ParseLevel(embeddableMappingType));
        SelectableData currentSelectableData = null;
        while (reader.hasNext() && !parseLevel.isEmpty()) {
            ParseLevel currentLevel = (ParseLevel)parseLevel.getCurrent();
            assert (currentLevel != null);
            switch ((JsonDocumentItemType)((Object)reader.next())) {
                case VALUE_KEY: {
                    EmbeddableMappingType currentEmbeddableMappingType = currentLevel.embeddableMappingType;
                    assert (currentEmbeddableMappingType != null) : "Value keys are only valid for objects";
                    assert (currentSelectableData == null);
                    Object selectableName = reader.getObjectKeyName();
                    int selectableIndex = currentEmbeddableMappingType.getSelectableIndex((String)selectableName);
                    if (selectableIndex < 0) {
                        throw new IllegalArgumentException(String.format("Could not find selectable [%s] in embeddable type [%s] for JSON processing.", selectableName, currentEmbeddableMappingType.getMappedJavaType().getJavaTypeClass().getName()));
                    }
                    SelectableMapping selectableMapping = currentEmbeddableMappingType.getJdbcValueSelectable(selectableIndex);
                    currentSelectableData = new SelectableData((String)selectableName, selectableIndex, selectableMapping);
                    break;
                }
                case ARRAY_START: {
                    assert (currentSelectableData != null);
                    Object selectableName = currentSelectableData.selectableMapping.getJdbcMapping();
                    if (!(selectableName instanceof BasicPluralType)) {
                        throw new IllegalArgumentException(String.format("Can't parse JSON array for selectable [%s] which is not of type BasicPluralType.", ParseLevel.determineSelectablePath(parseLevel, currentSelectableData)));
                    }
                    BasicPluralType pluralType = (BasicPluralType)selectableName;
                    parseLevel.push(new ParseLevel(currentSelectableData, pluralType));
                    currentSelectableData = null;
                    break;
                }
                case ARRAY_END: {
                    assert (currentLevel.arrayType != null);
                    assert (currentLevel.selectableData != null);
                    parseLevel.pop();
                    ParseLevel parentLevel = (ParseLevel)parseLevel.getCurrent();
                    assert (parentLevel.embeddableMappingType != null);
                    parentLevel.addValue(currentLevel.selectableData, currentLevel.arrayType.getJdbcJavaType().wrap(currentLevel.subArrayObjectList, options));
                    break;
                }
                case OBJECT_START: {
                    JdbcMapping jdbcMapping = currentLevel.determineJdbcMapping(currentSelectableData);
                    JdbcType selectableIndex = jdbcMapping.getJdbcType();
                    if (!(selectableIndex instanceof AggregateJdbcType)) {
                        throw new IllegalArgumentException(String.format("Can't parse JSON object for selectable [%s] which is not of type AggregateJdbcType.", ParseLevel.determineSelectablePath(parseLevel, currentSelectableData)));
                    }
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)selectableIndex;
                    parseLevel.push(new ParseLevel(currentSelectableData, aggregateJdbcType.getEmbeddableMappingType()));
                    currentSelectableData = null;
                    break;
                }
                case OBJECT_END: {
                    Object objectValue;
                    EmbeddableMappingType currentEmbeddableMappingType = currentLevel.embeddableMappingType;
                    assert (currentEmbeddableMappingType != null);
                    parseLevel.pop();
                    if (returnEmbeddable) {
                        StructAttributeValues attributeValues = StructHelper.getAttributeValues(embeddableMappingType, currentLevel.objectArray, options);
                        objectValue = StructHelper.instantiate(embeddableMappingType, attributeValues);
                    } else {
                        objectValue = currentLevel.objectArray;
                    }
                    if (parseLevel.isEmpty()) {
                        return (X)objectValue;
                    }
                    ((ParseLevel)parseLevel.getCurrent()).addValue(currentLevel.selectableData, objectValue);
                    break;
                }
                case NULL_VALUE: {
                    currentLevel.addValue(currentSelectableData, null);
                    currentSelectableData = null;
                    break;
                }
                case NUMERIC_VALUE: {
                    JdbcMapping jdbcMapping = currentLevel.determineJdbcMapping(currentSelectableData);
                    currentLevel.addValue(currentSelectableData, adapter.fromNumericValue(jdbcMapping.getJdbcJavaType(), jdbcMapping.getJdbcType(), reader, options));
                    currentSelectableData = null;
                    break;
                }
                case BOOLEAN_VALUE: {
                    currentLevel.addValue(currentSelectableData, reader.getBooleanValue() ? Boolean.TRUE : Boolean.FALSE);
                    currentSelectableData = null;
                    break;
                }
                case VALUE: {
                    JdbcMapping jdbcMapping = currentLevel.determineJdbcMapping(currentSelectableData);
                    currentLevel.addValue(currentSelectableData, adapter.fromValue(jdbcMapping.getJdbcJavaType(), jdbcMapping.getJdbcType(), reader, options));
                    currentSelectableData = null;
                }
            }
        }
        throw new IllegalArgumentException("Expected JSON object end, but none found.");
    }

    public static <X> X deserialize(EmbeddableMappingType embeddableMappingType, JsonDocumentReader reader, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        JsonDocumentItemType event;
        if (!reader.hasNext() || (event = (JsonDocumentItemType)((Object)reader.next())) == JsonDocumentItemType.NULL_VALUE) {
            return null;
        }
        if (event != JsonDocumentItemType.OBJECT_START) {
            throw new IllegalArgumentException("Malformed JSON. Expected object but got: " + String.valueOf((Object)event));
        }
        X result = JsonHelper.consumeJsonDocumentItems(reader, embeddableMappingType, returnEmbeddable, options);
        assert (!reader.hasNext());
        return result;
    }

    public static <X> X arrayFromString(JavaType<X> javaType, JdbcType elementJdbcType, String string, WrapperOptions options) throws SQLException {
        if (string == null) {
            return null;
        }
        return JsonHelper.deserializeArray(javaType, elementJdbcType, new StringJsonDocumentReader(string), options);
    }

    public static <X> X deserializeArray(JavaType<X> javaType, JdbcType elementJdbcType, JsonDocumentReader reader, WrapperOptions options) throws SQLException {
        JsonDocumentItemType event;
        if (!reader.hasNext() || (event = (JsonDocumentItemType)((Object)reader.next())) == JsonDocumentItemType.NULL_VALUE) {
            return null;
        }
        if (event != JsonDocumentItemType.ARRAY_START) {
            throw new IllegalArgumentException("Malformed JSON. Expected array but got: " + String.valueOf((Object)event));
        }
        CustomArrayList arrayList = new CustomArrayList();
        JavaType elementJavaType = ((BasicPluralJavaType)((Object)javaType)).getElementJavaType();
        Class<?> preferredJavaTypeClass = elementJdbcType.getPreferredJavaTypeClass(options);
        JavaType<Object> jdbcJavaType = preferredJavaTypeClass == null || preferredJavaTypeClass == elementJavaType.getJavaTypeClass() ? elementJavaType : options.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(preferredJavaTypeClass);
        JsonValueJDBCTypeAdapter adapter = JsonValueJDBCTypeAdapterFactory.getAdapter(reader, false);
        block8: while (reader.hasNext()) {
            JsonDocumentItemType type = (JsonDocumentItemType)((Object)reader.next());
            switch (type) {
                case ARRAY_END: {
                    assert (!reader.hasNext());
                    return javaType.wrap(arrayList, options);
                }
                case NULL_VALUE: {
                    arrayList.add((Object)null);
                    continue block8;
                }
                case NUMERIC_VALUE: {
                    arrayList.add(adapter.fromNumericValue(jdbcJavaType, elementJdbcType, reader, options));
                    continue block8;
                }
                case BOOLEAN_VALUE: {
                    arrayList.add(reader.getBooleanValue() ? Boolean.TRUE : Boolean.FALSE);
                    continue block8;
                }
                case VALUE: {
                    arrayList.add(adapter.fromValue(jdbcJavaType, elementJdbcType, reader, options));
                    continue block8;
                }
                case OBJECT_START: {
                    assert (elementJdbcType instanceof JsonJdbcType);
                    EmbeddableMappingType embeddableMappingType = ((JsonJdbcType)elementJdbcType).getEmbeddableMappingType();
                    arrayList.add(JsonHelper.consumeJsonDocumentItems(reader, embeddableMappingType, true, options));
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("Unexpected JSON type " + String.valueOf((Object)type));
        }
        throw new IllegalArgumentException("Expected JSON array end, but none found.");
    }

    private static class CustomArrayList
    extends AbstractCollection<Object>
    implements Collection<Object> {
        Object[] array = ArrayHelper.EMPTY_OBJECT_ARRAY;
        int size;

        private CustomArrayList() {
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.array.length;
            if (minCapacity > oldCapacity) {
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                newCapacity = Math.max(Math.max(newCapacity, minCapacity), 10);
                this.array = Arrays.copyOf(this.array, newCapacity);
            }
        }

        public Object[] getUnderlyingArray() {
            return this.array;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(Object o) {
            if (this.size == this.array.length) {
                this.ensureCapacity(this.size + 1);
            }
            this.array[this.size++] = o;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            for (int i = 0; i < this.size; ++i) {
                if (!Objects.equals(o, this.array[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                int index;

                @Override
                public boolean hasNext() {
                    return this.index != size;
                }

                @Override
                public Object next() {
                    if (this.index == size) {
                        throw new NoSuchElementException();
                    }
                    return array[this.index++];
                }
            };
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOf(this.array, this.size);
        }

        @Override
        @AllowReflection
        public <T> T[] toArray(T[] a) {
            T[] r = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
            for (int i = 0; i < this.size; ++i) {
                r[i] = this.array[i];
            }
            return null;
        }
    }
}

