/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.spi;

import jakarta.persistence.Timeout;
import org.hibernate.Incubating;
import org.hibernate.Timeouts;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.PessimisticLockStyle;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;

@Incubating
public interface LockingSupport {
    public Metadata getMetadata();

    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy();

    public static interface Metadata {
        default public PessimisticLockStyle getPessimisticLockStyle() {
            return PessimisticLockStyle.CLAUSE;
        }

        default public LockTimeoutType getLockTimeoutType(Timeout timeout) {
            return switch (timeout.milliseconds()) {
                case -2, 0 -> LockTimeoutType.NONE;
                case -1 -> LockTimeoutType.QUERY;
                default -> LockTimeoutType.NONE;
            };
        }

        default public RowLockStrategy getReadRowLockStrategy() {
            return this.getWriteRowLockStrategy();
        }

        default public RowLockStrategy getWriteRowLockStrategy() {
            return RowLockStrategy.NONE;
        }

        public OuterJoinLockingType getOuterJoinLockingType();

        @Deprecated
        default public boolean supportsForUpdate() {
            PessimisticLockStyle lockStyle = this.getPessimisticLockStyle();
            return lockStyle == PessimisticLockStyle.CLAUSE;
        }

        @Deprecated
        default public boolean supportsWait() {
            return this.supportsNoWait();
        }

        @Deprecated
        default public boolean supportsNoWait() {
            return this.getLockTimeoutType(Timeouts.NO_WAIT) == LockTimeoutType.QUERY;
        }

        @Deprecated
        default public boolean supportsSkipLocked() {
            return this.getLockTimeoutType(Timeouts.SKIP_LOCKED) == LockTimeoutType.QUERY;
        }
    }
}

