/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.List;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.FullNameLDAPStorageMapper;

public class FullNameLDAPStorageMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "full-name-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties = FullNameLDAPStorageMapperFactory.getConfigProps(null);

    private static List<ProviderConfigProperty> getConfigProps(ComponentModel parent) {
        boolean readOnly = false;
        if (parent != null) {
            LDAPConfig config = new LDAPConfig((MultivaluedHashMap<String, String>)parent.getConfig());
            readOnly = config.getEditMode() != UserStorageProvider.EditMode.WRITABLE;
        }
        return ProviderConfigurationBuilder.create().property().name("ldap.full.name.attribute").label("LDAP Full Name Attribute").helpText("Name of LDAP attribute, which contains fullName of user. Usually it will be 'cn' ").type("String").defaultValue((Object)"cn").add().property().name("read.only").label("Read Only").helpText("For Read-only is data imported from LDAP to Keycloak DB, but it's not saved back to LDAP when user is updated in Keycloak.").type("boolean").defaultValue((Object)String.valueOf(readOnly)).add().property().name("write.only").label("Write Only").helpText("For Write-only is data propagated to LDAP when user is created or updated in Keycloak. But this mapper is not used to propagate data from LDAP back into Keycloak. This setting is useful if you configured separate firstName and lastName attribute mappers and you want to use those to read attribute from LDAP into Keycloak").type("boolean").defaultValue((Object)String.valueOf(!readOnly)).add().build();
    }

    @Override
    public String getHelpText() {
        return "Used to map full-name of user from single attribute in LDAP (usually 'cn' attribute) to firstName and lastName attributes of UserModel in Keycloak DB";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public List<ProviderConfigProperty> getConfigProperties(RealmModel realm, ComponentModel parent) {
        return FullNameLDAPStorageMapperFactory.getConfigProps(parent);
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        this.checkMandatoryConfigAttribute("ldap.full.name.attribute", "LDAP Full Name Attribute", config);
        boolean readOnly = AbstractLDAPStorageMapper.parseBooleanParameter(config, "read.only");
        boolean writeOnly = AbstractLDAPStorageMapper.parseBooleanParameter(config, "write.only");
        ComponentModel parent = realm.getComponent(config.getParentId());
        if (parent == null) {
            throw new ComponentValidationException("can't find parent component model", new Object[0]);
        }
        LDAPConfig cfg = new LDAPConfig((MultivaluedHashMap<String, String>)parent.getConfig());
        UserStorageProvider.EditMode editMode = cfg.getEditMode();
        if (writeOnly && cfg.getEditMode() != UserStorageProvider.EditMode.WRITABLE) {
            throw new ComponentValidationException("ldapErrorCantWriteOnlyForReadOnlyLdap", new Object[0]);
        }
        if (writeOnly && readOnly) {
            throw new ComponentValidationException("ldapErrorCantWriteOnlyAndReadOnly", new Object[0]);
        }
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new FullNameLDAPStorageMapper(mapperModel, federationProvider);
    }
}

