/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.health.AsyncHealthCheckFactory;
import io.smallrye.health.HealthLogging;
import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.health.api.HealthContentFilter;
import io.smallrye.health.api.HealthGroup;
import io.smallrye.health.api.HealthType;
import io.smallrye.health.api.Wellness;
import io.smallrye.health.api.event.HealthStatusChangeEvent;
import io.smallrye.health.registry.HealthRegistries;
import io.smallrye.health.registry.HealthRegistryImpl;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.ObserverException;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;

@ApplicationScoped
public class SmallRyeHealthReporter {
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
    @Inject
    @Liveness
    Instance<HealthCheck> livenessChecks;
    @Inject
    @Readiness
    Instance<HealthCheck> readinessChecks;
    @Inject
    @Wellness
    Instance<HealthCheck> wellnessChecks;
    @Inject
    @Startup
    Instance<HealthCheck> startupChecks;
    @Inject
    @Any
    Instance<HealthCheck> allHealthChecks;
    @Inject
    @Liveness
    Instance<AsyncHealthCheck> asyncLivenessChecks;
    @Inject
    @Readiness
    Instance<AsyncHealthCheck> asyncReadinessChecks;
    @Inject
    @Wellness
    Instance<AsyncHealthCheck> asyncWellnessChecks;
    @Inject
    @Startup
    Instance<AsyncHealthCheck> asyncStartupChecks;
    @Inject
    @Any
    Instance<AsyncHealthCheck> allAsyncHealthChecks;
    @Inject
    @Any
    Instance<HealthContentFilter> healthContentFilters;
    @Inject
    BeanManager beanManager;
    HealthRegistryImpl livenessHealthRegistry = (HealthRegistryImpl)HealthRegistries.getRegistry(HealthType.LIVENESS);
    HealthRegistryImpl readinessHealthRegistry = (HealthRegistryImpl)HealthRegistries.getRegistry(HealthType.READINESS);
    HealthRegistryImpl wellnessHealthRegistry = (HealthRegistryImpl)HealthRegistries.getRegistry(HealthType.WELLNESS);
    HealthRegistryImpl startupHealthRegistry = (HealthRegistryImpl)HealthRegistries.getRegistry(HealthType.STARTUP);
    boolean contextPropagated = false;
    HealthCheckResponse.Status emptyChecksOutcome = HealthCheckResponse.Status.UP;
    int timeoutSeconds = 60;
    Map<String, String> additionalProperties = new ConcurrentHashMap<String, String>();
    Map<String, Boolean> healthChecksConfigs = new ConcurrentHashMap<String, Boolean>();
    boolean delayHealthCheckInit = false;
    String defaultHealthGroup = null;
    @Inject
    AsyncHealthCheckFactory asyncHealthCheckFactory;
    private final Map<String, Uni<HealthCheckResponse>> additionalChecks = new HashMap<String, Uni<HealthCheckResponse>>();
    private static final JsonProvider JSON_PROVIDER = JsonProvider.provider();
    private volatile boolean checksInitialized = false;
    private Uni<SmallRyeHealth> smallRyeHealthUni = null;
    private Uni<SmallRyeHealth> smallRyeLivenessUni = null;
    private Uni<SmallRyeHealth> smallRyeReadinessUni = null;
    private Uni<SmallRyeHealth> smallryeWellnessUni = null;
    private Uni<SmallRyeHealth> smallryeStartupUni = null;
    private HealthCheckResponse.Status healthStatus = HealthCheckResponse.Status.UP;
    private HealthCheckResponse.Status livenessStatus = HealthCheckResponse.Status.UP;
    private HealthCheckResponse.Status readinessStatus = HealthCheckResponse.Status.UP;
    private HealthCheckResponse.Status startupStatus = HealthCheckResponse.Status.UP;
    private HealthCheckResponse.Status wellnessStatus = HealthCheckResponse.Status.UP;
    private boolean additionalListsChanged = false;
    private List<Uni<HealthCheckResponse>> livenessUnis = new CopyOnWriteArrayList<Uni<HealthCheckResponse>>();
    private List<Uni<HealthCheckResponse>> readinessUnis = new CopyOnWriteArrayList<Uni<HealthCheckResponse>>();
    private List<Uni<HealthCheckResponse>> wellnessUnis = new CopyOnWriteArrayList<Uni<HealthCheckResponse>>();
    private List<Uni<HealthCheckResponse>> startupUnis = new CopyOnWriteArrayList<Uni<HealthCheckResponse>>();
    @Inject
    @Default
    Event<HealthStatusChangeEvent> healthEvent;
    @Inject
    @Liveness
    Event<HealthStatusChangeEvent> livenessEvent;
    @Inject
    @Readiness
    Event<HealthStatusChangeEvent> readinessEvent;
    @Inject
    @Wellness
    Event<HealthStatusChangeEvent> wellnessEvent;
    @Inject
    @Startup
    Event<HealthStatusChangeEvent> startupEvent;

    @PostConstruct
    public void postConstruct() {
        try {
            Config config = ConfigProvider.getConfig();
            this.contextPropagated = config.getOptionalValue("io.smallrye.health.context.propagation", Boolean.class).orElse(false);
            this.emptyChecksOutcome = config.getOptionalValue("io.smallrye.health.emptyChecksOutcome", HealthCheckResponse.Status.class).orElse(HealthCheckResponse.Status.UP);
            this.timeoutSeconds = config.getOptionalValue("io.smallrye.health.timeout.seconds", Integer.class).orElse(60);
            this.additionalProperties = ((SmallRyeConfig)config).getOptionalValues("io.smallrye.health.additional.property", String.class, String.class).orElse(new ConcurrentHashMap());
            this.delayHealthCheckInit = config.getOptionalValue("io.smallrye.health.delayChecksInitializations", Boolean.class).orElse(false);
            this.defaultHealthGroup = config.getOptionalValue("io.smallrye.health.defaultHealthGroup", String.class).orElse(null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.asyncHealthCheckFactory == null) {
            this.asyncHealthCheckFactory = new AsyncHealthCheckFactory();
        }
        if (!this.delayHealthCheckInit) {
            this.initChecks();
        }
    }

    private synchronized void initChecks() {
        if (this.checksInitialized) {
            return;
        }
        this.initUnis(this.livenessUnis, this.livenessChecks, this.asyncLivenessChecks);
        this.initUnis(this.readinessUnis, this.readinessChecks, this.asyncReadinessChecks);
        this.initUnis(this.wellnessUnis, this.wellnessChecks, this.asyncWellnessChecks);
        this.initUnis(this.startupUnis, this.startupChecks, this.asyncStartupChecks);
        this.checksInitialized = true;
    }

    private void initUnis(List<Uni<HealthCheckResponse>> list, Instance<HealthCheck> checks, Instance<AsyncHealthCheck> asyncChecks) {
        if (checks != null) {
            for (Instance.Handle handle : checks.handles()) {
                HealthCheck check = (HealthCheck)handle.get();
                if (check == null || !this.isHealthCheckEnabled(check)) continue;
                list.add((Uni<HealthCheckResponse>)this.asyncHealthCheckFactory.callSync(check).chain(response -> {
                    if (handle.getBean().getScope().equals(Dependent.class)) {
                        handle.destroy();
                    }
                    return Uni.createFrom().item(response);
                }));
            }
        }
        if (asyncChecks != null) {
            for (Instance.Handle handle : asyncChecks.handles()) {
                AsyncHealthCheck asyncCheck = (AsyncHealthCheck)handle.get();
                if (asyncCheck == null || !this.isHealthCheckEnabled(asyncCheck)) continue;
                list.add((Uni<HealthCheckResponse>)this.asyncHealthCheckFactory.callAsync(asyncCheck).chain(response -> {
                    if (handle.getBean().getScope().equals(Dependent.class)) {
                        handle.destroy();
                    }
                    return Uni.createFrom().item(response);
                }));
            }
        }
    }

    private void initUnis(List<Uni<HealthCheckResponse>> list, Iterable<HealthCheck> checks, Iterable<AsyncHealthCheck> asyncChecks) {
        if (checks != null) {
            for (HealthCheck check : checks) {
                if (check == null || !this.isHealthCheckEnabled(check)) continue;
                list.add(this.asyncHealthCheckFactory.callSync(check));
            }
        }
        if (asyncChecks != null) {
            for (AsyncHealthCheck asyncCheck : asyncChecks) {
                if (asyncCheck == null || !this.isHealthCheckEnabled(asyncCheck)) continue;
                list.add(this.asyncHealthCheckFactory.callAsync(asyncCheck));
            }
        }
    }

    private List<Uni<HealthCheckResponse>> recreateUnis(Iterable<HealthCheck> checks, Iterable<AsyncHealthCheck> asyncChecks) {
        ArrayList<Uni<HealthCheckResponse>> list = new ArrayList<Uni<HealthCheckResponse>>();
        this.initUnis(list, checks, asyncChecks);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportHealth(OutputStream out, SmallRyeHealth health) {
        JsonObject payload = health.getPayload();
        if (health.isDown() && HealthLogging.logger.isInfoEnabled()) {
            HealthLogging.logger.healthDownStatus(payload.toString());
        }
        if (this.healthContentFilters != null) {
            for (Instance.Handle handle : this.healthContentFilters.handles()) {
                try {
                    payload = ((HealthContentFilter)handle.get()).filter(payload);
                }
                finally {
                    if (handle.getBean().getScope().equals(Dependent.class)) {
                        handle.destroy();
                    }
                }
            }
        }
        JsonWriterFactory factory = JSON_PROVIDER.createWriterFactory(JSON_CONFIG);
        JsonWriter writer = factory.createWriter(out);
        writer.writeObject(payload);
        writer.close();
    }

    public SmallRyeHealth getHealth() {
        return (SmallRyeHealth)this.getHealthAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getLiveness() {
        return (SmallRyeHealth)this.getLivenessAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getReadiness() {
        return (SmallRyeHealth)this.getReadinessAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getStartup() {
        return (SmallRyeHealth)this.getStartupAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    @Experimental(value="Wellness experimental checks")
    public SmallRyeHealth getWellness() {
        return (SmallRyeHealth)this.getWellnessAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getHealthGroup(String groupName) {
        return (SmallRyeHealth)this.getHealthGroupAsync(groupName).await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getHealthGroups() {
        return (SmallRyeHealth)this.getHealthGroupsAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getHealthAsync() {
        this.smallRyeHealthUni = this.getHealthAsync(this.smallRyeHealthUni, HealthType.LIVENESS, HealthType.READINESS, HealthType.WELLNESS, HealthType.STARTUP);
        return this.smallRyeHealthUni;
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getLivenessAsync() {
        this.smallRyeLivenessUni = this.getHealthAsync(this.smallRyeLivenessUni, HealthType.LIVENESS);
        return this.smallRyeLivenessUni;
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getReadinessAsync() {
        this.smallRyeReadinessUni = this.getHealthAsync(this.smallRyeReadinessUni, HealthType.READINESS);
        return this.smallRyeReadinessUni;
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getStartupAsync() {
        this.smallryeStartupUni = this.getHealthAsync(this.smallryeStartupUni, HealthType.STARTUP);
        return this.smallryeStartupUni;
    }

    @Experimental(value="Asynchronous Health Check procedures & wellness experimental checks")
    public Uni<SmallRyeHealth> getWellnessAsync() {
        this.smallryeWellnessUni = this.getHealthAsync(this.smallryeWellnessUni, HealthType.WELLNESS);
        return this.smallryeWellnessUni;
    }

    @Experimental(value="Asynchronous Health Check procedures and Health Groups")
    public Uni<SmallRyeHealth> getHealthGroupAsync(String groupName) {
        ArrayList<Uni<HealthCheckResponse>> checks = new ArrayList<Uni<HealthCheckResponse>>();
        if (this.allHealthChecks != null && this.allAsyncHealthChecks != null) {
            if (groupName.equals(this.defaultHealthGroup)) {
                this.initUnis(checks, this.getHealthChecksWithoutHealthGroup(HealthCheck.class), this.getHealthChecksWithoutHealthGroup(AsyncHealthCheck.class));
            }
            this.initUnis(checks, (Instance<HealthCheck>)this.allHealthChecks.select(new Annotation[]{HealthGroup.Literal.of((String)groupName)}), (Instance<AsyncHealthCheck>)this.allAsyncHealthChecks.select(new Annotation[]{HealthGroup.Literal.of((String)groupName)}));
        }
        checks.addAll(((HealthRegistryImpl)HealthRegistries.getHealthGroupRegistry(groupName)).getChecks(this.healthChecksConfigs));
        return this.getHealthResult(checks).map(HealthResult::toSmallRyeHealth);
    }

    @Experimental(value="Asynchronous Health Check procedures and Health Groups")
    public Uni<SmallRyeHealth> getHealthGroupsAsync() {
        ArrayList<Uni<HealthCheckResponse>> checks = new ArrayList<Uni<HealthCheckResponse>>();
        if (this.defaultHealthGroup != null) {
            this.initUnis(checks, this.allHealthChecks, this.allAsyncHealthChecks);
        } else {
            if (this.beanManager != null) {
                this.initUnis(checks, this.getHealthGroupsChecks(HealthCheck.class), this.getHealthGroupsChecks(AsyncHealthCheck.class));
            }
            HealthRegistries.getHealthGroupRegistries().forEach(healthRegistry -> checks.addAll(((HealthRegistryImpl)healthRegistry).getChecks(this.healthChecksConfigs)));
        }
        return this.getHealthResult(checks).map(HealthResult::toSmallRyeHealth);
    }

    public void addHealthCheck(HealthCheck check) {
        if (check != null) {
            this.additionalChecks.put(check.getClass().getName(), this.asyncHealthCheckFactory.callSync(check));
            this.additionalListsChanged = true;
        }
    }

    public void addHealthCheck(AsyncHealthCheck check) {
        if (check != null) {
            this.additionalChecks.put(check.getClass().getName(), this.asyncHealthCheckFactory.callAsync(check));
            this.additionalListsChanged = true;
        }
    }

    public void removeHealthCheck(HealthCheck check) {
        this.additionalChecks.remove(check.getClass().getName());
        this.additionalListsChanged = true;
    }

    public void removeHealthCheck(AsyncHealthCheck check) {
        this.additionalChecks.remove(check.getClass().getName());
        this.additionalListsChanged = true;
    }

    public void setContextPropagated(boolean contextPropagated) {
        this.contextPropagated = contextPropagated;
    }

    public void setEmptyChecksOutcome(String emptyChecksOutcome) {
        Objects.requireNonNull(emptyChecksOutcome);
        this.emptyChecksOutcome = HealthCheckResponse.Status.valueOf((String)emptyChecksOutcome);
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        if (timeoutSeconds < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative.");
        }
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        Objects.requireNonNull(additionalProperties);
        this.additionalProperties = new ConcurrentHashMap<String, String>(additionalProperties);
    }

    public void setHealthChecksConfigs(Map<String, Boolean> healthChecksConfigs) {
        Objects.requireNonNull(healthChecksConfigs);
        this.healthChecksConfigs = new ConcurrentHashMap<String, Boolean>(healthChecksConfigs);
        this.checksInitialized = false;
    }

    private <T> List<T> getHealthGroupsChecks(Class<T> checkClass) {
        Iterator iterator = this.beanManager.getBeans(checkClass, new Annotation[]{Any.Literal.INSTANCE}).iterator();
        ArrayList<Object> groupHealthChecks = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Bean bean = (Bean)iterator.next();
            if (!bean.getQualifiers().stream().anyMatch(annotation -> annotation.annotationType().equals(HealthGroup.class))) continue;
            groupHealthChecks.add(this.beanManager.getReference(bean, (Type)bean.getBeanClass(), this.beanManager.createCreationalContext((Contextual)bean)));
        }
        return groupHealthChecks;
    }

    private <T> List<T> getHealthChecksWithoutHealthGroup(Class<T> checkClass) {
        Iterator iterator = this.beanManager.getBeans(checkClass, new Annotation[]{Any.Literal.INSTANCE}).iterator();
        ArrayList<Object> healthChecks = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Bean bean = (Bean)iterator.next();
            if (!bean.getQualifiers().stream().noneMatch(annotation -> annotation.annotationType().equals(HealthGroup.class))) continue;
            healthChecks.add(this.beanManager.getReference(bean, (Type)bean.getBeanClass(), this.beanManager.createCreationalContext((Contextual)bean)));
        }
        return healthChecks;
    }

    private Uni<SmallRyeHealth> getHealthAsync(Uni<SmallRyeHealth> cachedHealth, HealthType ... types) {
        if (this.contextPropagated) {
            return this.computeHealthWithContext(types);
        }
        if (!this.checksInitialized) {
            this.initChecks();
        }
        if (this.additionalListsChanged(types) || this.additionalListsChanged || cachedHealth == null) {
            this.additionalListsChanged = false;
            cachedHealth = this.computeHealth(types);
        }
        return cachedHealth;
    }

    private Uni<SmallRyeHealth> computeHealth(HealthType[] types) {
        HashMap<HealthType, Uni<HealthResult>> healthResults = new HashMap<HealthType, Uni<HealthResult>>();
        block6: for (HealthType type : types) {
            switch (type) {
                case LIVENESS: {
                    healthResults.put(HealthType.LIVENESS, this.getHealthResult(this.livenessUnis, this.livenessHealthRegistry.getChecks(this.healthChecksConfigs)));
                    continue block6;
                }
                case READINESS: {
                    healthResults.put(HealthType.READINESS, this.getHealthResult(this.readinessUnis, this.readinessHealthRegistry.getChecks(this.healthChecksConfigs)));
                    continue block6;
                }
                case WELLNESS: {
                    healthResults.put(HealthType.WELLNESS, this.getHealthResult(this.wellnessUnis, this.wellnessHealthRegistry.getChecks(this.healthChecksConfigs)));
                    continue block6;
                }
                case STARTUP: {
                    healthResults.put(HealthType.STARTUP, this.getHealthResult(this.startupUnis, this.startupHealthRegistry.getChecks(this.healthChecksConfigs)));
                }
            }
        }
        return this.processHealthResults(healthResults);
    }

    private Uni<SmallRyeHealth> computeHealthWithContext(HealthType ... types) {
        HashMap<HealthType, Uni<HealthResult>> healthResults = new HashMap<HealthType, Uni<HealthResult>>();
        block6: for (HealthType type : types) {
            switch (type) {
                case LIVENESS: {
                    healthResults.put(HealthType.LIVENESS, this.getHealthResult(this.recreateUnis((Iterable<HealthCheck>)this.livenessChecks, (Iterable<AsyncHealthCheck>)this.asyncLivenessChecks), this.livenessHealthRegistry.getChecks(this.healthChecksConfigs)));
                    continue block6;
                }
                case READINESS: {
                    healthResults.put(HealthType.READINESS, this.getHealthResult(this.recreateUnis((Iterable<HealthCheck>)this.readinessChecks, (Iterable<AsyncHealthCheck>)this.asyncReadinessChecks), this.readinessHealthRegistry.getChecks(this.healthChecksConfigs)));
                    continue block6;
                }
                case WELLNESS: {
                    healthResults.put(HealthType.WELLNESS, this.getHealthResult(this.recreateUnis((Iterable<HealthCheck>)this.wellnessChecks, (Iterable<AsyncHealthCheck>)this.asyncWellnessChecks), this.wellnessHealthRegistry.getChecks(this.healthChecksConfigs)));
                    continue block6;
                }
                case STARTUP: {
                    healthResults.put(HealthType.STARTUP, this.getHealthResult(this.recreateUnis((Iterable<HealthCheck>)this.startupChecks, (Iterable<AsyncHealthCheck>)this.asyncStartupChecks), this.startupHealthRegistry.getChecks(this.healthChecksConfigs)));
                }
            }
        }
        return this.processHealthResults(healthResults);
    }

    private Uni<HealthResult> emptyHealthResult() {
        return Uni.createFrom().item((Object)new HealthResult(this.emptyChecksOutcome));
    }

    private Uni<SmallRyeHealth> processHealthResults(Map<HealthType, Uni<HealthResult>> healthResults) {
        Uni<HealthResult> additionalHealthResult = this.emptyHealthResult();
        if (!this.additionalChecks.isEmpty()) {
            additionalHealthResult = this.getHealthResult(this.additionalChecks.values());
        }
        return Uni.combine().all().unis(healthResults.getOrDefault(HealthType.LIVENESS, this.emptyHealthResult()), healthResults.getOrDefault(HealthType.READINESS, this.emptyHealthResult()), healthResults.getOrDefault(HealthType.WELLNESS, this.emptyHealthResult()), healthResults.getOrDefault(HealthType.STARTUP, this.emptyHealthResult()), additionalHealthResult).with((liveness, readiness, wellness, startup, additionalChecks) -> {
            HealthResult result = new HealthResult();
            this.livenessStatus = this.handleHealthResult((HealthResult)liveness, HealthType.LIVENESS, this.livenessEvent, this.livenessStatus, result);
            this.readinessStatus = this.handleHealthResult((HealthResult)readiness, HealthType.READINESS, this.readinessEvent, this.readinessStatus, result);
            this.wellnessStatus = this.handleHealthResult((HealthResult)wellness, HealthType.WELLNESS, this.wellnessEvent, this.wellnessStatus, result);
            this.startupStatus = this.handleHealthResult((HealthResult)startup, HealthType.STARTUP, this.startupEvent, this.startupStatus, result);
            if (!additionalChecks.checks.isEmpty()) {
                result.checks.addAll(additionalChecks.checks);
                if (result.status == HealthCheckResponse.Status.UP && additionalChecks.status == HealthCheckResponse.Status.DOWN) {
                    result.status = HealthCheckResponse.Status.DOWN;
                }
            }
            this.fireGlobalHealthStatusChangeIfNeeded();
            return result.toSmallRyeHealth();
        });
    }

    private HealthCheckResponse.Status handleHealthResult(HealthResult partialResult, HealthType healthType, Event<HealthStatusChangeEvent> event, HealthCheckResponse.Status currentStatus, HealthResult result) {
        if (!partialResult.checks.isEmpty()) {
            result.checks.addAll(partialResult.checks);
            if (result.status == HealthCheckResponse.Status.UP && partialResult.status == HealthCheckResponse.Status.DOWN) {
                result.status = HealthCheckResponse.Status.DOWN;
            }
            return this.fireEventIfStatusChanged(event, healthType, currentStatus, partialResult.status);
        }
        return currentStatus;
    }

    private HealthCheckResponse.Status fireEventIfStatusChanged(Event<HealthStatusChangeEvent> event, HealthType healthType, HealthCheckResponse.Status oldStatus, HealthCheckResponse.Status newStatus) {
        if (oldStatus != newStatus) {
            try {
                event.fire((Object)new HealthStatusChangeEvent(healthType, newStatus));
            }
            catch (ObserverException e) {
                HealthLogging.logger.healthChangeObserverError(e);
            }
        }
        return newStatus;
    }

    private void fireGlobalHealthStatusChangeIfNeeded() {
        HealthCheckResponse.Status newStatus = HealthCheckResponse.Status.UP;
        if (List.of(this.livenessStatus, this.readinessStatus, this.startupStatus, this.wellnessStatus).contains(HealthCheckResponse.Status.DOWN)) {
            newStatus = HealthCheckResponse.Status.DOWN;
        }
        if (this.healthStatus != newStatus) {
            this.healthStatus = newStatus;
            try {
                this.healthEvent.fire((Object)new HealthStatusChangeEvent(newStatus));
            }
            catch (ObserverException e) {
                HealthLogging.logger.healthChangeObserverError(e);
            }
        }
    }

    private boolean additionalListsChanged(HealthType ... types) {
        boolean needRecompute = false;
        block6: for (HealthType type : types) {
            switch (type) {
                case LIVENESS: {
                    if (!this.livenessHealthRegistry.checksChanged()) continue block6;
                    needRecompute = true;
                    continue block6;
                }
                case READINESS: {
                    if (!this.readinessHealthRegistry.checksChanged()) continue block6;
                    needRecompute = true;
                    continue block6;
                }
                case WELLNESS: {
                    if (!this.wellnessHealthRegistry.checksChanged()) continue block6;
                    needRecompute = true;
                    continue block6;
                }
                case STARTUP: {
                    if (!this.startupHealthRegistry.checksChanged()) continue block6;
                    needRecompute = true;
                }
            }
        }
        return needRecompute;
    }

    @SafeVarargs
    private Uni<HealthResult> getHealthResult(Collection<Uni<HealthCheckResponse>> ... checkLists) {
        ArrayList<Uni<HealthCheckResponse>> healthCheckUnis = new ArrayList<Uni<HealthCheckResponse>>();
        if (checkLists != null) {
            for (Collection<Uni<HealthCheckResponse>> checks : checkLists) {
                healthCheckUnis.addAll(checks);
            }
        }
        if (healthCheckUnis.isEmpty()) {
            return this.emptyHealthResult();
        }
        return Uni.combine().all().unis(healthCheckUnis).with(responses -> {
            HealthResult healthResult = new HealthResult();
            for (Object o : responses) {
                HealthCheckResponse response = (HealthCheckResponse)o;
                if (healthResult.status == HealthCheckResponse.Status.UP && response.getStatus() == HealthCheckResponse.Status.DOWN) {
                    healthResult.status = HealthCheckResponse.Status.DOWN;
                }
                healthResult.checks.add(response);
            }
            return healthResult;
        });
    }

    private boolean isHealthCheckEnabled(HealthCheck healthCheck) {
        return this.isEnabled(healthCheck.getClass().getName()) && this.isEnabled(healthCheck.getClass().getSuperclass().getName());
    }

    private boolean isHealthCheckEnabled(AsyncHealthCheck asyncHealthCheck) {
        return this.isEnabled(asyncHealthCheck.getClass().getName()) && this.isEnabled(asyncHealthCheck.getClass().getSuperclass().getName());
    }

    private boolean isEnabled(String checkClassName) {
        return this.healthChecksConfigs.computeIfAbsent(checkClassName, s -> {
            try {
                return ConfigProvider.getConfig().getOptionalValue("io.smallrye.health.check." + checkClassName + ".enabled", Boolean.class).orElse(true);
            }
            catch (IllegalStateException illegalStateException) {
                return true;
            }
        });
    }

    private final class HealthResult {
        HealthCheckResponse.Status status = HealthCheckResponse.Status.UP;
        List<HealthCheckResponse> checks = new ArrayList<HealthCheckResponse>();

        public HealthResult() {
        }

        public HealthResult(HealthCheckResponse.Status status) {
            this.status = status;
        }

        public SmallRyeHealth toSmallRyeHealth() {
            return this.createSmallRyeHealth();
        }

        private SmallRyeHealth createSmallRyeHealth() {
            JsonObjectBuilder builder = JSON_PROVIDER.createObjectBuilder();
            JsonArray checkResults = this.createChecksJsonArray();
            builder.add("status", checkResults.isEmpty() ? SmallRyeHealthReporter.this.emptyChecksOutcome.toString() : this.status.toString());
            builder.add("checks", (JsonValue)checkResults);
            if (!SmallRyeHealthReporter.this.additionalProperties.isEmpty()) {
                SmallRyeHealthReporter.this.additionalProperties.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
            }
            return new SmallRyeHealth(builder.build());
        }

        private JsonArray createChecksJsonArray() {
            JsonArrayBuilder results = JSON_PROVIDER.createArrayBuilder();
            for (HealthCheckResponse response : this.checks) {
                this.handleResponse(response, results);
            }
            return results.build();
        }

        private void handleResponse(HealthCheckResponse response, JsonArrayBuilder results) {
            JsonObject responseJson = this.jsonObject(response);
            results.add((JsonValue)responseJson);
        }

        private JsonObject jsonObject(HealthCheckResponse response) {
            JsonObjectBuilder builder = JSON_PROVIDER.createObjectBuilder();
            builder.add("name", response.getName());
            builder.add("status", response.getStatus().toString());
            response.getData().ifPresent(d -> {
                JsonObjectBuilder data = JSON_PROVIDER.createObjectBuilder();
                for (Map.Entry entry : d.entrySet()) {
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        data.add((String)entry.getKey(), (String)value);
                        continue;
                    }
                    if (value instanceof Long) {
                        data.add((String)entry.getKey(), ((Long)value).longValue());
                        continue;
                    }
                    if (!(value instanceof Boolean)) continue;
                    data.add((String)entry.getKey(), ((Boolean)value).booleanValue());
                }
                builder.add("data", (JsonValue)data.build());
            });
            return builder.build();
        }
    }
}

