/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.jruby.AbstractRubyMethod;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.invokers.ConstructorInvoker;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.MethodInvoker;
import org.jruby.java.invokers.StaticFieldGetter;
import org.jruby.java.invokers.StaticFieldSetter;
import org.jruby.java.invokers.StaticMethodInvoker;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ArrayJavaProxyCreator;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.util.ClassUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.binding.MethodGatherer;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyObjectInputStream;

public class JavaProxy
extends RubyObject {
    Object object;
    private static final RubyHash.VisitorWithState<Map> MapPopulatorVisitor = new RubyHash.VisitorWithState<Map>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Map map2) {
            map2.put(key2.asString().toString(), value2.asString().toString());
        }
    };
    private static final String NONPERSISTENT_IVAR_MESSAGE = "instance vars on non-persistent Java type {0} (https://github.com/jruby/jruby/wiki/Persistence)";
    private static final String NONPERSISTENT_SINGLETON_MESSAGE = "singleton on non-persistent Java type {0} (https://github.com/jruby/jruby/wiki/Persistence)";

    public JavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public JavaProxy(Ruby runtime2, RubyClass klazz, Object object) {
        super(runtime2, klazz);
        this.object = object;
    }

    public static RubyClass createJavaProxy(ThreadContext context, RubyClass Object2, RubyModule JavaProxyMethods2) {
        return (RubyClass)((RubyModule)Define.defineClass(context, "JavaProxy", Object2, JavaProxy::new).defineMethods(context, JavaProxy.class)).include(context, JavaProxyMethods2);
    }

    @Deprecated
    @JRubyMethod(meta=true)
    public static IRubyObject wrap(ThreadContext context, IRubyObject self2, IRubyObject object) {
        Object value2 = JavaUtil.unwrapJava(object, null);
        if (value2 == null) {
            return context.nil;
        }
        if (value2 instanceof Class) {
            Class clazz = (Class)value2;
            return Java.getProxyClass(context, clazz);
        }
        return value2.getClass().isArray() ? new ArrayJavaProxy(context.runtime, Access.getClass(context, "ArrayJavaProxy"), value2) : new ConcreteJavaProxy(context.runtime, Access.getClass(context, "ConcreteJavaProxy"), value2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject java_class(IRubyObject self2) {
        return JavaProxy.getJavaClass((RubyClass)self2);
    }

    public static IRubyObject getJavaClass(RubyModule target2) {
        return (JavaProxy)target2.getInternalVariable("java_class");
    }

    public static void setJavaClass(RubyClass target2, Class<?> javaClass) {
        JavaProxy.setJavaClass(target2.getClassRuntime(), target2, javaClass);
    }

    @Deprecated(since="10.0")
    public static void setJavaClass(IRubyObject target2, Class<?> javaClass) {
        JavaProxy.setJavaClass(((RubyBasicObject)target2).getCurrentContext(), target2, javaClass);
    }

    public static void setJavaClass(ThreadContext context, IRubyObject target2, Class<?> javaClass) {
        JavaProxy.setJavaClass(context.runtime, target2.getInternalVariables(), javaClass);
    }

    static void setJavaClass(Ruby runtime2, InternalVariables target2, Class<?> javaClass) {
        JavaProxy.setJavaClass(target2, Java.getInstance(runtime2, javaClass));
    }

    private static void setJavaClass(InternalVariables target2, IRubyObject javaClass) {
        target2.setInternalVariable("java_class", javaClass);
    }

    @Override
    public final Object dataGetStruct() {
        return this.object;
    }

    @Override
    public final void dataWrapStruct(Object object) {
        this.object = object instanceof JavaObject ? ((JavaObject)object).getValue() : (object instanceof JavaProxy ? ((JavaProxy)object).object : object);
    }

    public final Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object unwrap() {
        return this.getObject();
    }

    @Deprecated
    protected JavaObject asJavaObject(Object object) {
        return JavaObject.wrap(this.getRuntime(), object);
    }

    @Override
    public Class<?> getJavaClass() {
        return this.getObject().getClass();
    }

    @JRubyMethod(meta=true, frame=true)
    public static IRubyObject inherited(ThreadContext context, IRubyObject recv2, IRubyObject subclass) {
        if (JavaProxy.getJavaClass((RubyClass)subclass) == null) {
            JavaProxy.setJavaClass((InternalVariables)((RubyClass)subclass), JavaProxy.getJavaClass((RubyClass)recv2));
        }
        return Helpers.invokeSuper(context, recv2, subclass, Block.NULL_BLOCK);
    }

    @Deprecated(since="10.0")
    public static RubyClass singleton_class(IRubyObject self2) {
        return JavaProxy.singleton_class(self2.getRuntime().getCurrentContext(), self2);
    }

    @JRubyMethod(meta=true)
    public static RubyClass singleton_class(ThreadContext context, IRubyObject self2) {
        return self2.singletonClass(context);
    }

    @JRubyMethod(name={"[]"}, meta=true, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Class<?> type2 = JavaUtil.getJavaClass(context, (RubyModule)self2);
        if (args2.length > 0) {
            return new ArrayJavaProxyCreator(context, type2, args2);
        }
        Class<?> arrayType = Array.newInstance(type2, 0).getClass();
        return Java.getProxyClass(context, arrayType);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject new_array(ThreadContext context, IRubyObject self2, IRubyObject len) {
        Class<?> componentType = JavaUtil.getJavaClass(context, (RubyModule)self2);
        int length2 = Convert.toInt(context, len);
        return ArrayJavaProxy.newArray(context, componentType, length2);
    }

    @JRubyMethod(name={"__persistent__="}, meta=true)
    public static IRubyObject persistent(IRubyObject clazz, IRubyObject value2) {
        ((RubyClass)clazz).getRealClass().setCacheProxy(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"__persistent__"}, meta=true)
    public static IRubyObject persistent(ThreadContext context, IRubyObject clazz) {
        return Convert.asBoolean(context, ((RubyClass)clazz).getRealClass().getCacheProxy());
    }

    @Override
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        super.initialize_copy(context, original);
        this.setObject(((JavaProxy)original).cloneObject());
        return this;
    }

    protected Object cloneObject() {
        Object object = this.getObject();
        if (object instanceof Cloneable) {
            Object clone2 = JavaUtil.clone(object);
            return clone2 == null ? object : clone2;
        }
        return object;
    }

    private static Map<String, String> getFieldListFromArgs(ThreadContext context, IRubyObject[] args2) {
        HashMap<String, String> map2 = new HashMap<String, String>(args2.length, 1.0f);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject arg2 = args2[i2];
            if (arg2 instanceof RubyHash) {
                ((RubyHash)arg2).visitAll(context, MapPopulatorVisitor, map2);
                continue;
            }
            String value2 = arg2.asString().toString();
            map2.put(value2, value2);
        }
        return map2;
    }

    private static void installField(ThreadContext context, Map<String, String> fieldMap, Field field, RubyModule module, boolean asReader, boolean asWriter) {
        String fieldName = field.getName();
        Iterator<Map.Entry<String, String>> iter = fieldMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().equals(fieldName)) continue;
            JavaProxy.installField(context, entry.getValue(), field, module, asReader, (Boolean)asWriter);
            iter.remove();
            break;
        }
    }

    private static void installField(ThreadContext context, String asName, Field field, RubyModule target2, boolean asReader, Boolean asWriter) {
        if (Ruby.isSecurityRestricted() && !Modifier.isPublic(field.getModifiers())) {
            throw context.runtime.newSecurityError("Cannot change accessibility on field in restricted mode  '" + String.valueOf(field) + "'");
        }
        String fieldName = field.getName();
        if (Modifier.isStatic(field.getModifiers())) {
            if (asReader) {
                target2.singletonClass(context).addMethod(context, asName, new StaticFieldGetter(fieldName, target2, field));
            }
            if (asWriter == null || asWriter.booleanValue()) {
                if (Modifier.isFinal(field.getModifiers())) {
                    if (asWriter == null) {
                        return;
                    }
                    throw context.runtime.newSecurityError("Cannot change final field '" + String.valueOf(field) + "'");
                }
                target2.singletonClass(context).addMethod(context, asName + "=", new StaticFieldSetter(fieldName, target2, field));
            }
        } else {
            if (asReader) {
                target2.addMethod(context, asName, new InstanceFieldGetter(fieldName, target2, field));
            }
            if (asWriter == null || asWriter.booleanValue()) {
                if (Modifier.isFinal(field.getModifiers())) {
                    if (asWriter == null) {
                        return;
                    }
                    throw context.runtime.newSecurityError("Cannot change final field '" + String.valueOf(field) + "'");
                }
                target2.addMethod(context, asName + "=", new InstanceFieldSetter(fieldName, target2, field));
            }
        }
    }

    public static void installField(ThreadContext context, String asName, Field field, RubyModule target2) {
        JavaProxy.installField(context, asName, field, target2, true, null);
    }

    private static void findFields(ThreadContext context, RubyModule topModule, IRubyObject[] args2, boolean asReader, boolean asWriter) {
        Map<String, String> fieldMap = JavaProxy.getFieldListFromArgs(context, args2);
        for (RubyModule module = topModule; module != null; module = module.getSuperClass()) {
            Class<?> javaClass = JavaUtil.getJavaClass(module, null);
            if (javaClass == null) continue;
            Field[] fields2 = ClassUtils.getDeclaredFields(javaClass);
            for (int j = 0; j < fields2.length; ++j) {
                JavaProxy.installField(context, fieldMap, fields2[j], module, asReader, asWriter);
            }
        }
        if (!fieldMap.isEmpty()) {
            throw JavaProxy.undefinedFieldError(context, topModule.getName(context), fieldMap.keySet().iterator().next());
        }
    }

    private static RaiseException undefinedFieldError(ThreadContext context, String javaClassName, String name2) {
        return Error.nameError(context, "undefined field '" + name2 + "' for class '" + javaClassName + "'", name2);
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_accessor(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)self2, args2, true, true);
        return context.nil;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_reader(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)self2, args2, true, false);
        return context.nil;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_writer(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)self2, args2, false, true);
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"equal?"})
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        RubyBoolean rubyBoolean;
        if (other instanceof JavaProxy) {
            JavaProxy proxy2 = (JavaProxy)other;
            rubyBoolean = Convert.asBoolean(context, this.getObject() == proxy2.getObject());
        } else {
            rubyBoolean = context.fals;
        }
        return rubyBoolean;
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        Ruby runtime2 = context.runtime;
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(context, name2, new Class[0]));
        return method2.invokeDirect(context, this.getObject());
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime2 = context.runtime;
        JavaProxy.checkArgSizeMismatch(runtime2, 0, argTypesAry);
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(context, name2, new Class[0]));
        return method2.invokeDirect(context, this.getObject());
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime2 = context.runtime;
        JavaProxy.checkArgSizeMismatch(runtime2, 1, argTypesAry);
        Class argTypeClass = argTypesAry.eltInternal(0).toJava(Class.class);
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(context, name2, argTypeClass));
        return method2.invokeDirect(context, this.getObject(), arg0.toJava(argTypeClass));
    }

    @JRubyMethod(required=1, rest=true, checkArity=false)
    public IRubyObject java_send(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        Ruby runtime2 = context.runtime;
        String name2 = args2[0].asJavaString();
        RubyArray argTypesAry = args2[1].convertToArray();
        int argsLen = argc - 2;
        JavaProxy.checkArgSizeMismatch(runtime2, argsLen, argTypesAry);
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
        Object[] javaArgs = new Object[argsLen];
        for (int i2 = 0; i2 < argsLen; ++i2) {
            javaArgs[i2] = args2[i2 + 2].toJava(argTypesClasses[i2]);
        }
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(context, name2, argTypesClasses));
        return method2.invokeDirect(context, this.getObject(), javaArgs);
    }

    private static void checkArgSizeMismatch(Ruby runtime2, int expected, RubyArray argTypes) {
        if (argTypes.size() != expected) {
            Class[] argTypesClasses = (Class[])argTypes.toArray(new Class[argTypes.size()]);
            throw JavaMethod.newArgSizeMismatchError(runtime2, argTypesClasses);
        }
    }

    @JRubyMethod
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        return this.getRubyMethod(context, name2, new Class[0]);
    }

    @JRubyMethod
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
        return this.getRubyMethod(context, name2, argTypesClasses);
    }

    @Deprecated(since="10.0")
    public IRubyObject marshal_dump() {
        return this.marshal_dump(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject marshal_dump(ThreadContext context) {
        if (!Serializable.class.isAssignableFrom(this.object.getClass())) {
            throw Error.typeError(context, "Java type is not serializable, cannot be marshaled " + String.valueOf(this.getJavaClass()));
        }
        try {
            ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
            new ObjectOutputStream(bytes2).writeObject(this.object);
            return Create.newString(context, new ByteList(bytes2.toByteArray(), false));
        }
        catch (IOException ex) {
            throw Error.typeError(context, "Java type is not serializable: " + ex.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject str) {
        try {
            ByteList byteList = str.convertToString().getByteList();
            ByteArrayInputStream bytes2 = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            this.object = new JRubyObjectInputStream(context.runtime, bytes2).readObject();
            return this;
        }
        catch (IOException ex) {
            throw context.runtime.newIOErrorFromException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw Error.typeError(context, "Class not found unmarshaling Java type: " + ex.getLocalizedMessage());
        }
    }

    @Override
    protected int inspectHashCode() {
        return System.identityHashCode(this.object);
    }

    private Method getMethod(ThreadContext context, String name2, Class ... argTypes) {
        Class<?> originalClass = this.getObject().getClass();
        Method[] holder = new Method[]{null};
        Predicate<Method[]> predicate = classMethods -> {
            for (Method method2 : classMethods) {
                if (!method2.getName().equals(name2) || !Arrays.equals(method2.getParameterTypes(), argTypes)) continue;
                holder[0] = method2;
                return false;
            }
            return true;
        };
        MethodGatherer.eachAccessibleMethod(originalClass, predicate, predicate);
        if (holder[0] == null) {
            throw JavaMethod.newMethodNotFoundError(context, originalClass, name2 + String.valueOf(CodegenUtils.prettyParams(argTypes)), name2);
        }
        return holder[0];
    }

    private MethodInvoker getMethodInvoker(Method method2) {
        if (Modifier.isStatic(method2.getModifiers())) {
            return new StaticMethodInvoker((RubyModule)this.metaClass.getMetaClass(), () -> Helpers.arrayOf(method2), method2.getName());
        }
        return new InstanceMethodInvoker((RubyModule)this.metaClass, () -> Helpers.arrayOf(method2), method2.getName());
    }

    private RubyMethod getRubyMethod(ThreadContext context, String name2, Class ... argTypes) {
        Method jmethod = this.getMethod(context, name2, argTypes);
        if (Modifier.isStatic(jmethod.getModifiers())) {
            RubyClass sourceModule = this.metaClass.singletonClass(context);
            return RubyMethod.newMethod(sourceModule, CodegenUtils.prettyParams(argTypes).toString(), sourceModule, name2, new CacheEntry(this.getMethodInvoker(jmethod), sourceModule, this.metaClass.getGeneration()), this.getMetaClass());
        }
        RubyClass sourceModule = this.metaClass;
        return RubyMethod.newMethod(sourceModule, CodegenUtils.prettyParams(argTypes).toString(), sourceModule, name2, new CacheEntry(this.getMethodInvoker(jmethod), sourceModule, this.metaClass.getGeneration()), this);
    }

    @Override
    public <T> T toJava(Class<T> type2) {
        Object object = this.getObject();
        Class<?> clazz = object.getClass();
        if (type2.isAssignableFrom(clazz)) {
            return type2.cast(object);
        }
        if (type2.isAssignableFrom(this.getClass())) {
            return type2.cast(this);
        }
        throw Error.typeError(this.getRuntime().getCurrentContext(), "failed to coerce " + clazz.getName() + " to " + type2.getName());
    }

    @Override
    public Object getVariable(int index2) {
        this.checkVariablesOnProxy();
        return super.getVariable(index2);
    }

    @Override
    public void setVariable(int index2, Object value2) {
        this.checkVariablesOnProxy();
        super.setVariable(index2, value2);
    }

    public void checkVariablesOnProxy() {
        this.confirmCachedProxy(NONPERSISTENT_IVAR_MESSAGE);
    }

    @Override
    public RubyClass singletonClass(ThreadContext context) {
        this.confirmCachedProxy(NONPERSISTENT_SINGLETON_MESSAGE);
        return super.singletonClass(context);
    }

    private void confirmCachedProxy(String message2) {
        RubyClass realClass = this.metaClass.getRealClass();
        if (!realClass.getCacheProxy()) {
            Ruby runtime2 = this.getRuntime();
            if (Java.OBJECT_PROXY_CACHE) {
                runtime2.getWarnings().warnOnce(IRubyWarnings.ID.NON_PERSISTENT_JAVA_PROXY, MessageFormat.format(message2, realClass));
            } else {
                Warn.warn(runtime2.getCurrentContext(), MessageFormat.format(message2, realClass));
                realClass.setCacheProxy(true);
                runtime2.getJavaSupport().getObjectProxyCache().put(this.getObject(), this);
            }
        }
    }

    public static class ClassMethods {
        @JRubyMethod(name={"const_missing"}, required=1, meta=true, visibility=Visibility.PRIVATE, frame=true)
        public static IRubyObject const_missing(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            return Java.get_inner_class(context, (RubyModule)self2, name2);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_method(ThreadContext context, IRubyObject proxyClass, IRubyObject rubyName) {
            String name2 = rubyName.asJavaString();
            return ClassMethods.getRubyMethod(context, proxyClass, name2, new Class[0]);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_method(ThreadContext context, IRubyObject proxyClass, IRubyObject rubyName, IRubyObject argTypes) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            return ClassMethods.getRubyMethod(context, proxyClass, name2, argTypesClasses);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName) {
            String name2 = rubyName.asJavaString();
            Ruby runtime2 = context.runtime;
            JavaMethod method2 = new JavaMethod(runtime2, ClassMethods.getMethodFromClass(context, recv2, name2, new Class[0]));
            return method2.invokeStaticDirect(context);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName, IRubyObject argTypes) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Ruby runtime2 = context.runtime;
            JavaProxy.checkArgSizeMismatch(runtime2, 0, argTypesAry);
            JavaMethod method2 = new JavaMethod(runtime2, ClassMethods.getMethodFromClass(context, recv2, name2, new Class[0]));
            return method2.invokeStaticDirect(context);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Ruby runtime2 = context.runtime;
            JavaProxy.checkArgSizeMismatch(runtime2, 1, argTypesAry);
            Class argTypeClass = argTypesAry.eltInternal(0).toJava(Class.class);
            JavaMethod method2 = new JavaMethod(runtime2, ClassMethods.getMethodFromClass(context, recv2, name2, argTypeClass));
            return method2.invokeStaticDirect(context, arg0.toJava(argTypeClass));
        }

        @JRubyMethod(required=1, rest=true, checkArity=false, meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
            int argc = Arity.checkArgumentCount(context, args2, 1, -1);
            switch (argc) {
                case 1: {
                    return ClassMethods.java_send(context, recv2, args2[0]);
                }
                case 2: {
                    return ClassMethods.java_send(context, recv2, args2[0], args2[1]);
                }
                case 3: {
                    return ClassMethods.java_send(context, recv2, args2[0], args2[1], args2[2]);
                }
            }
            Ruby runtime2 = context.runtime;
            String name2 = args2[0].asJavaString();
            RubyArray argTypesAry = args2[1].convertToArray();
            int argsLen = argc - 2;
            JavaProxy.checkArgSizeMismatch(runtime2, argsLen, argTypesAry);
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
            Object[] javaArgs = new Object[argsLen];
            for (int i2 = 0; i2 < argsLen; ++i2) {
                javaArgs[i2] = args2[i2 + 2].toJava(argTypesClasses[i2]);
            }
            JavaMethod method2 = new JavaMethod(runtime2, ClassMethods.getMethodFromClass(context, recv2, name2, argTypesClasses));
            return method2.invokeStaticDirect(context, javaArgs);
        }

        @JRubyMethod(meta=true, visibility=Visibility.PRIVATE)
        public static IRubyObject java_alias(ThreadContext context, IRubyObject clazz, IRubyObject newName, IRubyObject rubyName) {
            return ClassMethods.java_alias(context, clazz, newName, rubyName, Create.newEmptyArray(context));
        }

        @JRubyMethod(meta=true, visibility=Visibility.PRIVATE)
        public static IRubyObject java_alias(ThreadContext context, IRubyObject klass, IRubyObject newName, IRubyObject rubyName, IRubyObject argTypes) {
            RubyModule proxyClass = Convert.castAsModule(context, klass);
            String name2 = rubyName.asJavaString();
            String newNameStr = newName.asJavaString();
            Class[] argTypesClasses = (Class[])argTypes.convertToArray().toArray(ClassUtils.EMPTY_CLASS_ARRAY);
            Class<?> clazz = JavaUtil.getJavaClass(context, proxyClass);
            switch (name2) {
                case "<init>": {
                    Constructor constructor2 = ClassMethods.getConstructorFromClass(context, clazz, name2, argTypesClasses);
                    ConstructorInvoker invoker = new ConstructorInvoker(proxyClass, () -> Helpers.arrayOf(constructor2), newNameStr);
                    proxyClass.addMethod(context, newNameStr, invoker);
                    break;
                }
                default: {
                    Method method2 = ClassMethods.getMethodFromClass(context, clazz, name2, argTypesClasses);
                    if (Modifier.isStatic(method2.getModifiers())) {
                        StaticMethodInvoker invoker = new StaticMethodInvoker((RubyModule)proxyClass.getMetaClass(), () -> Helpers.arrayOf(method2), newNameStr);
                        proxyClass.singletonClass(context).addMethod(context, newNameStr, invoker);
                        break;
                    }
                    InstanceMethodInvoker invoker = new InstanceMethodInvoker(proxyClass, () -> Helpers.arrayOf(method2), newNameStr);
                    proxyClass.addMethod(context, newNameStr, invoker);
                }
            }
            return context.nil;
        }

        private static AbstractRubyMethod getRubyMethod(ThreadContext context, IRubyObject clazz, String name2, Class ... argTypesClasses) {
            RubyModule proxyClass = Convert.castAsModule(context, clazz);
            Method method2 = ClassMethods.getMethodFromClass(context, JavaUtil.getJavaClass(context, proxyClass), name2, argTypesClasses);
            String prettyName = name2 + String.valueOf(CodegenUtils.prettyParams(argTypesClasses));
            if (Modifier.isStatic(method2.getModifiers())) {
                StaticMethodInvoker invoker = new StaticMethodInvoker(proxyClass, () -> Helpers.arrayOf(method2), name2);
                return RubyMethod.newMethod(proxyClass, prettyName, proxyClass, name2, new CacheEntry(invoker, proxyClass, proxyClass.getGeneration()), clazz);
            }
            InstanceMethodInvoker invoker = new InstanceMethodInvoker(proxyClass, () -> Helpers.arrayOf(method2), name2);
            return RubyUnboundMethod.newUnboundMethod(proxyClass, prettyName, proxyClass, name2, new CacheEntry(invoker, proxyClass, proxyClass.getGeneration()));
        }

        private static Method getMethodFromClass(ThreadContext context, IRubyObject klass, String name2, Class ... argTypes) {
            return ClassMethods.getMethodFromClass(context, JavaUtil.getJavaClass(context, (RubyModule)klass), name2, argTypes);
        }

        private static Method getMethodFromClass(ThreadContext context, Class<?> clazz, String name2, Class ... argTypes) {
            try {
                return clazz.getMethod(name2, argTypes);
            }
            catch (NoSuchMethodException e) {
                throw ClassMethods.newNameError(context, "Java method not found: " + ClassMethods.format(clazz, name2, argTypes), name2, e);
            }
        }

        private static Constructor getConstructorFromClass(ThreadContext context, Class<?> clazz, String name2, Class ... argTypes) {
            try {
                return clazz.getConstructor(argTypes);
            }
            catch (NoSuchMethodException e) {
                throw ClassMethods.newNameError(context, "Java initializer not found: " + ClassMethods.format(clazz, name2, argTypes), name2, e);
            }
        }

        private static String format(Class<?> clazz, String name2, Class ... argTypes) {
            return clazz.getName() + "." + name2 + String.valueOf(CodegenUtils.prettyParams(argTypes));
        }

        private static RaiseException newNameError(ThreadContext context, String msg, String name2, ReflectiveOperationException cause2) {
            RaiseException ex = Error.nameError(context, msg, name2);
            ex.initCause(cause2);
            return ex;
        }
    }
}

