/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AlignedComponentPacker;
import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InternalDataTypeComponent;
import ghidra.program.model.data.StructureInternal;
import ghidra.program.model.data.Undefined1DataType;
import java.util.List;

public class AlignedStructurePacker {
    private final StructureInternal structure;
    private final List<? extends InternalDataTypeComponent> components;
    private final DataOrganization dataOrganization;

    protected AlignedStructurePacker(StructureInternal structure, List<? extends InternalDataTypeComponent> components) {
        this.structure = structure;
        this.components = components;
        this.dataOrganization = structure.getDataOrganization();
    }

    /*
     * WARNING - void declaration
     */
    protected StructurePackResult pack() {
        int n;
        boolean componentsChanged = false;
        int componentCount = 0;
        AlignedComponentPacker packer = new AlignedComponentPacker(this.structure.getStoredPackingValue(), this.dataOrganization);
        for (InternalDataTypeComponent internalDataTypeComponent : this.components) {
            DataType componentDt = internalDataTypeComponent.getDataType();
            if (DataType.DEFAULT == componentDt) {
                internalDataTypeComponent.setDataType(Undefined1DataType.dataType);
                componentsChanged = true;
            }
            ++componentCount;
        }
        boolean bl = false;
        for (InternalDataTypeComponent internalDataTypeComponent : this.components) {
            void var5_7;
            boolean isLastComponent = ++var5_7 == componentCount;
            packer.addComponent(internalDataTypeComponent, isLastComponent);
        }
        int defaultAlignment = packer.getDefaultAlignment();
        int n2 = packer.getLength();
        componentsChanged |= packer.componentsChanged();
        int alignment = defaultAlignment;
        AlignmentType alignmentType = this.structure.getAlignmentType();
        if (alignmentType != AlignmentType.DEFAULT) {
            int minAlign = alignmentType == AlignmentType.MACHINE ? this.dataOrganization.getMachineAlignment() : this.structure.getExplicitMinimumAlignment();
            alignment = Math.max(defaultAlignment, minAlign);
        }
        if (n2 != 0) {
            n = DataOrganizationImpl.getAlignedOffset(alignment, n2);
        }
        return new StructurePackResult(componentCount, n, alignment, componentsChanged);
    }

    public static StructurePackResult packComponents(StructureInternal structure, List<? extends InternalDataTypeComponent> components) {
        AlignedStructurePacker packer = new AlignedStructurePacker(structure, components);
        return packer.pack();
    }

    public static class StructurePackResult {
        public final int numComponents;
        public final int structureLength;
        public final int alignment;
        public final boolean componentsChanged;

        StructurePackResult(int numComponents, int structureLength, int alignment, boolean componentsChanged) {
            this.numComponents = numComponents;
            this.structureLength = structureLength;
            this.alignment = alignment;
            this.componentsChanged = componentsChanged;
        }
    }
}

