/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.prof;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.android.prof.ProfileConstants;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ProfileHeader
implements StructConverter {
    private byte[] magic;
    private byte[] version;
    private byte number_of_dex_files;
    private int uncompressed_size_of_zipped_data;
    private int compressed_data_size;
    private int _compressed_data_offset;

    public ProfileHeader(BinaryReader reader) throws IOException {
        this.magic = reader.readNextByteArray(ProfileConstants.kProfileMagic.length);
        this.version = reader.readNextByteArray(ProfileConstants.kProfileVersion_008.length);
        this.number_of_dex_files = reader.readNextByte();
        this.uncompressed_size_of_zipped_data = reader.readNextInt();
        this.compressed_data_size = reader.readNextInt();
        this._compressed_data_offset = (int)reader.getPointerIndex();
    }

    public String getMagic() {
        return new String(this.magic).trim();
    }

    public String getVersion() {
        return new String(this.version).trim();
    }

    public byte getNumberOfDexFiles() {
        return this.number_of_dex_files;
    }

    public int getUncompressedSizeOfZippedData() {
        return this.uncompressed_size_of_zipped_data;
    }

    public int getCompressedDataSize() {
        return this.compressed_data_size;
    }

    public int getCompressedDataOffset() {
        return this._compressed_data_offset;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(ProfileHeader.class);
    }
}

