/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.util.Arrays;

public final class BootImageUtil {
    public static final boolean isBootImage(Program program) {
        byte[] bytes = new byte[8];
        try {
            Address address = program.getMinAddress();
            program.getMemory().getBytes(address, bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Arrays.equals(bytes, "ANDROID!".getBytes());
    }

    public static final boolean isBootImage(BinaryReader reader) {
        try {
            String magic = reader.readAsciiString(0L, 8);
            return "ANDROID!".equals(magic);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean isVendorBootImage(Program program) {
        byte[] bytes = new byte[8];
        try {
            Address address = program.getMinAddress();
            program.getMemory().getBytes(address, bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Arrays.equals(bytes, "VNDRBOOT".getBytes());
    }

    public static final boolean isVendorBootImage(BinaryReader reader) {
        try {
            String magic = reader.readAsciiString(0L, 8);
            return "VNDRBOOT".equals(magic);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final String getOSVersionString(int os_version) {
        int a = (os_version & 0xFE000000) >>> 25;
        int b = (os_version & 0x1FC0000) >>> 18;
        int c = (os_version & 0x3F800) >>> 11;
        int y = (os_version & 0x7F0) >>> 4;
        int m = os_version & 0xF;
        return a + "." + b + "." + c + "_" + y + "_" + m;
    }
}

