/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import pdb.symbolserver.ContainerFileSymbolServer;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.LocalSymbolStore;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInputStream;
import pdb.symbolserver.SymbolServerInstanceCreatorContext;
import pdb.symbolserver.SymbolStore;

public class SameDirSymbolStore
implements SymbolStore,
SymbolServer.StatusRequiresContext {
    public static String PROGRAMS_IMPORT_LOCATION_DESCRIPTION_STR = "Program's Import Location";
    private final File rootDir;
    private final String programFilename;

    public static boolean isSameDirLocation(String locationString) {
        return ".".equals(locationString);
    }

    public static SymbolFileLocation createManuallySelectedSymbolFileLocation(File symbolFile, SymbolFileInfo symbolFileInfo) {
        SameDirSymbolStore samedirSymbolStore = new SameDirSymbolStore(symbolFile.getParentFile());
        SymbolFileLocation symbolFileLocation = new SymbolFileLocation(symbolFile.getName(), samedirSymbolStore, symbolFileInfo);
        return symbolFileLocation;
    }

    public static SymbolServer createInstance(String locationString, SymbolServerInstanceCreatorContext context) {
        FSRL programFSRL = context.getProgramFSRL();
        if (programFSRL != null && programFSRL.getNestingDepth() != 1) {
            return new ContainerFileSymbolServer(programFSRL);
        }
        String programFilename = programFSRL != null ? programFSRL.getName() : null;
        return new SameDirSymbolStore(context.getRootDir(), programFilename);
    }

    public SameDirSymbolStore(File rootDir) {
        this.rootDir = rootDir;
        this.programFilename = null;
    }

    public SameDirSymbolStore(File rootDir, String programFilename) {
        this.rootDir = rootDir;
        this.programFilename = programFilename;
    }

    @Override
    public File getAdminDir() {
        return this.rootDir;
    }

    @Override
    public File getFile(String path) {
        return new File(this.rootDir, path);
    }

    @Override
    public String giveFile(SymbolFileInfo symbolFileInfo, File f, String filename, TaskMonitor monitor) throws IOException {
        throw new IOException("Unsupported");
    }

    @Override
    public String putStream(SymbolFileInfo symbolFileInfo, SymbolServerInputStream streamInfo, String filename, TaskMonitor monitor) throws IOException {
        throw new IOException("Unsupported");
    }

    @Override
    public String getName() {
        return ".";
    }

    @Override
    public String getDescriptiveName() {
        return PROGRAMS_IMPORT_LOCATION_DESCRIPTION_STR + (String)(this.isValid() ? " - " + this.rootDir.getPath() : "");
    }

    @Override
    public boolean isValid(TaskMonitor monitor) {
        return this.isValid();
    }

    private boolean isValid() {
        return this.rootDir != null && this.rootDir.isDirectory();
    }

    @Override
    public boolean exists(String filename, TaskMonitor monitor) {
        return this.isValid() && this.getFile(filename).isFile();
    }

    @Override
    public List<SymbolFileLocation> find(SymbolFileInfo fileInfo, Set<FindOption> findOptions, TaskMonitor monitor) {
        ArrayList<SymbolFileLocation> results = new ArrayList<SymbolFileLocation>();
        if (this.isValid()) {
            LocalSymbolStore.searchLevel0(this.rootDir, this, fileInfo, findOptions, results, monitor);
            if (results.isEmpty() && this.programFilename != null) {
                List<CallSite> altPdbfilenames = List.of(this.programFilename + ".pdb", FilenameUtils.getBaseName((String)this.programFilename) + ".pdb");
                for (String string : altPdbfilenames) {
                    SymbolFileInfo altFileInfo = SymbolFileInfo.fromPdbIdentifiers(string, fileInfo.getIdentifiers());
                    LocalSymbolStore.searchLevel0(this.rootDir, this, altFileInfo, findOptions, results, monitor);
                    if (results.isEmpty()) continue;
                    break;
                }
            }
        }
        return results;
    }

    @Override
    public SymbolServerInputStream getFileStream(String filename, TaskMonitor monitor) throws IOException {
        if (!this.isValid(monitor)) {
            throw new IOException("Unknown rootdir");
        }
        File file = this.getFile(filename);
        return new SymbolServerInputStream(new FileInputStream(file), file.length());
    }

    @Override
    public String getFileLocation(String filename) {
        return this.getFile(filename).getPath();
    }

    public String toString() {
        return String.format("SameDirSymbolStore: [ dir: %s ]", this.rootDir);
    }
}

