/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.Compat;
import org.freeplane.features.map.DocuMapAttribute;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.features.url.mindmapmode.TemplateManager;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;

public class MapLoader {
    private final ModeController modeController;
    private URL sourceLocation;
    private URL newMapLocation;
    private boolean saveAfterLoading;
    private boolean withView;
    private boolean followSourceMap;
    private boolean unsetMapLocation;
    private boolean asDocumentation;
    private String selectedNodeId;
    private InputStream inputStream;

    public MapLoader(ModeController modeController) {
        this.modeController = modeController;
    }

    public MapLoader load(URL url) {
        this.sourceLocation = url;
        return this;
    }

    public MapLoader load(File file) {
        URL url = MapLoader.fileToUrlOrNull(file);
        return this.load(url);
    }

    public MapLoader setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public MapLoader newMapLocation(File associatedFile) {
        this.newMapLocation = MapLoader.fileToUrlOrNull(associatedFile);
        this.saveAfterLoading = false;
        return this;
    }

    public MapLoader followOldMap() {
        this.followSourceMap = true;
        return this;
    }

    public MapLoader unsetMapLocation(boolean follow) {
        this.followSourceMap = follow;
        return this.unsetMapLocation();
    }

    public MapLoader unsetMapLocation() {
        this.unsetMapLocation = true;
        return this;
    }

    public MapLoader saveAfterLoading() {
        this.saveAfterLoading = true;
        return this;
    }

    public MapLoader withView() {
        this.withView = true;
        return this;
    }

    public MapLoader asDocumentation() {
        this.asDocumentation = true;
        return this;
    }

    public MapLoader selectNodeById(String nodeId) {
        this.withView = true;
        this.selectedNodeId = nodeId;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MapModel getMap() {
        MapModel oldMap = this.controller().getMap();
        if (this.unsetMapLocation) {
            this.newMapLocation = null;
            this.saveAfterLoading = false;
        } else if (this.newMapLocation == null) {
            this.newMapLocation = this.sourceLocation;
        }
        this.asDocumentation = this.asDocumentation || this.modeController.containsExtension(DocuMapAttribute.class);
        try {
            MMapModel map = null;
            if (this.withView && this.sourceLocation != null) {
                this.assertNoTransaction(oldMap);
                map = this.selectMapViewByUrl();
            }
            if (map == null) {
                this.setWaitingCursor(true);
                try {
                    map = this.loadMap();
                    if (map == null) {
                        MapModel mapModel = null;
                        return mapModel;
                    }
                    if (this.withView) {
                        File newFile = this.urlToFileOrNull(this.newMapLocation);
                        if (newFile != null && !this.asDocumentation) {
                            this.fileManager().lock(map, newFile);
                        }
                        this.createMapView(map);
                        this.enableAutosave(map);
                    }
                }
                finally {
                    this.setWaitingCursor(false);
                }
            }
            if (!this.withView) return map;
            this.selectNode();
            return map;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setWaitingCursor(boolean isSet) {
        this.controller().getViewController().setWaitingCursor(isSet);
    }

    private void enableAutosave(MMapModel map) {
        if (!this.asDocumentation) {
            map.enableAutosave();
        }
    }

    private void selectNode() {
        if (this.selectedNodeId != null) {
            this.mapController().select(this.selectedNodeId);
        }
    }

    private void createMapView(MMapModel map) {
        this.mapController().createMapView(map);
    }

    private MMapModel selectMapViewByUrl() throws MalformedURLException {
        IMapViewManager mapViewManager;
        if (this.newMapLocation != null && (mapViewManager = this.controller().getMapViewManager()).tryToChangeToMapView(this.newMapLocation != null ? this.newMapLocation : this.sourceLocation)) {
            this.selectNode();
            MapModel map = this.controller().getMap();
            if (map instanceof MMapModel) {
                return (MMapModel)map;
            }
            throw new IllegalStateException("URL is already assigned to map with another type");
        }
        return null;
    }

    private static URL fileToUrlOrNull(File file) {
        try {
            return Compat.fileToUrl((File)file.getCanonicalFile());
        }
        catch (IOException e) {
            return null;
        }
    }

    private MMapModel loadMap() {
        Object rootText;
        URL actualSourceLocation;
        MMapModel loadedMap;
        if (this.newMapLocation != null && (loadedMap = this.mapController().getMap(this.newMapLocation)) != null) {
            if (this.newMapLocation.equals(this.sourceLocation)) {
                return loadedMap;
            }
            throw new IllegalStateException("URL is already assigned to another map");
        }
        URL uRL = this.inputStream != null ? null : (actualSourceLocation = this.asDocumentation ? this.sourceLocation : this.alternativeSourceLocation());
        if (actualSourceLocation == null) {
            return null;
        }
        final MMapModel map = this.createMindMap();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws FileNotFoundException, XMLException, URISyntaxException, IOException {
                    if (MapLoader.this.inputStream != null) {
                        MapLoader.this.loadMapContent(map);
                    } else if (actualSourceLocation != null) {
                        MapLoader.this.loadMap(map, actualSourceLocation);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
        if (map.getRootNode() == null) {
            map.createNewRoot();
        }
        if ((actualSourceLocation == null || !actualSourceLocation.equals(this.newMapLocation)) && (rootText = map.getRootNode().getUserObject()) instanceof TranslatedObject) {
            map.getRootNode().setText(rootText.toString());
        }
        map.setURL(this.newMapLocation);
        if (this.saveAfterLoading && !this.newMapLocation.equals(actualSourceLocation)) {
            this.fileManager().save(map, map.getFile());
        } else {
            map.setSaved(actualSourceLocation != null && actualSourceLocation.equals(this.newMapLocation));
        }
        this.mapController().addLoadedMap(map);
        this.mapController().fireMapCreated(map);
        this.setFollowedMapProperties(map);
        return map;
    }

    private void setFollowedMapProperties(MMapModel map) {
        if (this.sourceLocation != null && !this.sourceLocation.equals(this.newMapLocation)) {
            File sourceFile = Compat.urlToFile((URL)this.sourceLocation);
            if (sourceFile == null) {
                return;
            }
            MapStyleModel properties = MapStyleModel.getExtension((MapModel)map);
            URI sourceUri = sourceFile.toURI();
            String normalizedLocation = TemplateManager.INSTANCE.normalizeTemplateLocation(sourceUri).toString();
            properties.setProperty("associatedTemplateLocation", normalizedLocation);
            if (this.followSourceMap) {
                properties.setProperty("followedTemplateLocation", normalizedLocation);
                if (sourceUri.getScheme().equalsIgnoreCase("file")) {
                    File file = Paths.get(sourceUri).toFile();
                    properties.setProperty("followedMapLastTime", Long.toString(file.lastModified()));
                }
            }
        }
    }

    private void loadMap(MMapModel map, URL sourceLocation) throws IOException, XMLException, FileNotFoundException, XMLParseException {
        MFileManager fileManager = this.fileManager();
        if (sourceLocation != null) {
            File file = Compat.urlToFile((URL)sourceLocation);
            if (file == null) {
                fileManager.load(sourceLocation, map);
            } else {
                if (!file.canRead()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                if (file.length() != 0L) {
                    fileManager.setFile(map, file);
                    NodeModel root = fileManager.loadTree(map, file);
                    assert (map.getRootNode() == root);
                }
            }
        }
    }

    private MMapModel createMindMap() {
        MMapModel map = new MMapModel(this.mapController().duplicator());
        if (this.asDocumentation) {
            map.setReadOnly(true);
            map.addExtension((IExtension)DocuMapAttribute.INSTANCE);
        }
        return map;
    }

    private void loadMapContent(MMapModel map) throws IOException, XMLException {
        try (InputStreamReader urlStreamReader = new InputStreamReader(this.inputStream, StandardCharsets.UTF_8);){
            this.modeController.getMapController().getMapReader().createNodeTreeFromXml((MapModel)map, (Reader)urlStreamReader, MapWriter.Mode.FILE);
        }
    }

    private File urlToFileOrNull(URL url) throws URISyntaxException {
        return url != null ? Compat.urlToFile((URL)url) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL alternativeSourceLocation() {
        URL alternativeURL = null;
        try {
            File file = this.urlToFileOrNull(this.sourceLocation);
            if (file == null) {
                return this.sourceLocation;
            }
            if (!file.exists()) return this.sourceLocation;
            File alternativeFile = this.fileManager().getAlternativeFile(file, MFileManager.AlternativeFileMode.AUTOSAVE);
            if (alternativeFile == null) return null;
            if (!alternativeFile.getAbsoluteFile().equals(file.getAbsoluteFile())) return Compat.fileToUrl((File)alternativeFile);
            return this.sourceLocation;
        }
        catch (MalformedURLException malformedURLException) {
            return alternativeURL;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return alternativeURL;
    }

    private MFileManager fileManager() {
        return MFileManager.getController(this.modeController);
    }

    private MMapController mapController() {
        return (MMapController)this.modeController.getMapController();
    }

    private Controller controller() {
        return this.modeController.getController();
    }

    private void assertNoTransaction(MapModel oldMap) {
        if (oldMap == null) {
            return;
        }
        IUndoHandler oldUndoHandler = (IUndoHandler)oldMap.getExtension(IUndoHandler.class);
        int transactionLevel = oldUndoHandler.getTransactionLevel();
        if (!(transactionLevel == 0 || this.withView && transactionLevel == 1)) {
            throw new IllegalStateException("can not create map inside transaction");
        }
    }
}

