/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Curve;
import org.cugos.wkg.Dimension;

public class CircularString
extends Curve {
    private final List<Coordinate> coordinates;

    public CircularString(List<Coordinate> coordinates, Dimension dimension, String srid) {
        super(dimension, srid);
        this.coordinates = Collections.unmodifiableList(coordinates);
    }

    public CircularString(List<Coordinate> coordinates, Dimension dimension) {
        this(coordinates, dimension, null);
    }

    @Override
    public List<Coordinate> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.isEmpty();
    }

    @Override
    public int getNumberOfCoordinates() {
        return this.coordinates.size();
    }

    public static CircularString createEmpty() {
        return new CircularString(new ArrayList<Coordinate>(), Dimension.Two, null);
    }
}

