"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const exposes = __importStar(require("../lib/exposes"));
const m = __importStar(require("../lib/modernExtend"));
const modernExtend_1 = require("../lib/modernExtend");
const utils = __importStar(require("../lib/utils"));
const utils_1 = require("../lib/utils");
const e = exposes.presets;
const ea = exposes.access;
const fzLocal = {
    command_on_double: {
        cluster: "genOnOff",
        type: "commandOnWithRecallGlobalScene",
        convert: (model, msg, publish, options, meta) => {
            if ((0, utils_1.hasAlreadyProcessedMessage)(msg, model))
                return;
            const payload = { action: (0, utils_1.postfixWithEndpointName)("on_double", msg, model, meta) };
            (0, utils_1.addActionGroup)(payload, msg, model);
            return payload;
        },
    },
    command_off_double: {
        cluster: "genOnOff",
        type: "commandOffWithEffect",
        convert: (model, msg, publish, options, meta) => {
            if ((0, utils_1.hasAlreadyProcessedMessage)(msg, model))
                return;
            const payload = { action: (0, utils_1.postfixWithEndpointName)("off_double", msg, model, meta) };
            (0, utils_1.addActionGroup)(payload, msg, model);
            return payload;
        },
    },
};
const lsModernExtend = {
    groupIdExpose() {
        const result = {
            exposes: [e.numeric("action_group", ea.STATE).withDescription("Group where the action was triggered on")],
            isModernExtend: true,
        };
        return result;
    },
    commandsOnOffDouble() {
        return {
            exposes: [
                e
                    .enum("action", ea.STATE, ["on_double", "off_double"])
                    .withDescription("Triggered action (e.g. a button click)")
                    .withCategory("diagnostic"),
            ],
            fromZigbee: [fzLocal.command_on_double, fzLocal.command_off_double],
            isModernExtend: true,
            configure: [(0, modernExtend_1.setupConfigureForBinding)("genOnOff", "output")],
        };
    },
};
exports.definitions = [
    {
        zigbeeModel: ["Emotion"],
        model: "A319463",
        vendor: "L&S Lighting",
        description: "Home base",
        fromZigbee: m.light({ colorTemp: { range: [153, 454] }, color: true }).fromZigbee,
        toZigbee: m.light({ colorTemp: { range: [153, 454] }, color: true }).toZigbee,
        configure: m.light({ colorTemp: { range: [153, 454] }, color: true }).configure[0],
        exposes: (device, options) => {
            if (utils.isDummyDevice(device))
                return [e.light_brightness_colortemp_colorxy([153, 454])];
            return [
                ...device.endpoints
                    .filter((ep) => ep.ID !== 242)
                    .map((ep) => {
                    return e.light_brightness_colortemp_colorxy([153, 454]).withEndpoint(`l${ep.ID}`);
                }),
            ];
        },
        meta: { multiEndpoint: true },
        endpoint: (device) => {
            return Object.fromEntries(device.endpoints.filter((ep) => ep.ID !== 242).map((ep) => [`l${ep.ID}`, ep.ID]));
        },
    },
    {
        zigbeeModel: ["Mec Driver module"],
        model: "756200027",
        vendor: "L&S Lighting",
        description: "Mec Driver module 1-channel Zigbee (12V)",
        whiteLabel: [{ model: "756200028", vendor: "L&S Lighting", description: "Mec Driver module 1-channel Zigbee (24V)" }],
        extend: [m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        fingerprint: [
            { modelID: "Mec Driver module", softwareBuildID: "3.12.25-026" },
            { modelID: "Mec Driver module", softwareBuildID: "4.09.03-027" },
        ],
        model: "756200030",
        vendor: "L&S Lighting",
        description: "Mec Driver module 4-channel Zigbee (12V)",
        whiteLabel: [{ model: "756200031", vendor: "L&S Lighting", description: "Mec Driver module 4-channel Zigbee (24V)" }],
        extend: [
            m.deviceEndpoints({ endpoints: { 11: 11, 12: 12, 13: 13, 14: 14 } }),
            m.light({ endpointNames: ["11", "12", "13", "14"], colorTemp: { range: [153, 500] } }),
        ],
    },
    {
        zigbeeModel: ["SEMOTE"],
        model: "756200643",
        vendor: "L&S Lighting",
        description: "Zigbee remote",
        extend: [
            m.battery(),
            lsModernExtend.groupIdExpose(),
            lsModernExtend.commandsOnOffDouble(),
            m.commandsOnOff({ commands: ["on", "off"] }),
            m.commandsLevelCtrl({ commands: ["brightness_step_up", "brightness_step_down", "brightness_stop"] }),
            m.commandsColorCtrl({ commands: ["color_temperature_step_up", "color_temperature_step_down", "stop_move_step"] }),
        ],
    },
];
//# sourceMappingURL=ls.js.map