/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint.config;

import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.tools.command.lint.options.LintOptions;
import schemacrawler.tools.lint.config.LinterConfig;
import schemacrawler.tools.lint.config.LinterConfigs;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.type.CollectionType;
import tools.jackson.dataformat.yaml.YAMLMapper;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;
import us.fatehi.utility.string.StringFormat;

public final class LinterConfigUtility {
    public static final Logger LOGGER = Logger.getLogger(LinterConfigUtility.class.getName());
    private static final ObjectMapper mapper = new YAMLMapper();

    public static LinterConfigs readLinterConfigs(LintOptions lintOptions) {
        LinterConfigs linterConfigs = new LinterConfigs(lintOptions.getConfig());
        String linterConfigsFile = lintOptions.getLinterConfigs();
        if (!Utility.isBlank((String)linterConfigsFile)) {
            InputResource inputResource = (InputResource)InputResourceUtility.createInputResource((String)linterConfigsFile).orElseThrow(() -> new ConfigurationException("Could not load linter configs from file <%s>".formatted(linterConfigsFile)));
            try (BufferedReader reader = inputResource.openNewInputReader(StandardCharsets.UTF_8);){
                List<LinterConfig> linterConfigsList = LinterConfigUtility.readLinterConfigs(reader);
                for (LinterConfig linterConfig : linterConfigsList) {
                    linterConfigs.add(linterConfig);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Could not load linter configs from file <%s>".formatted(linterConfigsFile), (Throwable)e);
            }
        }
        return linterConfigs;
    }

    private static List<LinterConfig> readLinterConfigs(Reader reader) {
        Objects.requireNonNull(reader, "No input provided");
        try {
            CollectionType listType = mapper.getTypeFactory().constructCollectionType(List.class, LinterConfig.class);
            List linterConfigs = (List)mapper.readValue(reader, (JavaType)listType);
            Collections.sort(linterConfigs);
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Read <%d> linter configs", new Object[]{linterConfigs.size()}));
            return linterConfigs;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not read linter configs", (Throwable)e);
        }
    }

    private LinterConfigUtility() {
    }
}

