<!-- readme.md -->

<p align="center">
    <img src="https://ldaprecord.com/logo.svg" width="400">
</p>

<p align="center">Integrate LDAP into your Laravel application.</p>

<p align="center">
    <a href="https://laravel.com"><img src="https://img.shields.io/badge/Built_for-Laravel-green.svg?style=flat-square"></a>
    <a href="https://github.com/DirectoryTree/LdapRecord-Laravel/actions"><img src="https://img.shields.io/github/actions/workflow/status/directorytree/ldaprecord-laravel/run-tests.yml?branch=master&style=flat-square"></a>
    <a href="https://packagist.org/packages/directorytree/ldaprecord-laravel"><img src="https://img.shields.io/packagist/dt/directorytree/ldaprecord-laravel.svg?style=flat-square"></a>
    <a href="https://packagist.org/packages/directorytree/ldaprecord-laravel"><img src="https://img.shields.io/packagist/v/directorytree/ldaprecord-laravel.svg?style=flat-square"></a>
    <a href="https://packagist.org/packages/directorytree/ldaprecord-laravel"><img src="https://img.shields.io/packagist/l/directorytree/ldaprecord-laravel.svg?style=flat-square"></a>
</p>

<h4 align="center">
    <a href="https://ldaprecord.com/docs/laravel/v3/">Documentation</a>
    <span> · </span>
    <a href="https://github.com/DirectoryTree/LdapRecord-Browser">Directory Browser</a>
    <span> · </span>
    <a href="https://github.com/DirectoryTree/LdapRecord-Laravel/discussions/new">Post a Question</a>
</h4>

---

⭐️ **Developer Experience First**

LdapRecord focuses on clean, easy to understand syntax along with thorough documentation.

🔑  **Authenticate LDAP Users**

Allow LDAP users to log into your application and control which users can login via [Scopes](https://ldaprecord.com/docs/laravel/v3/usage/#scopes) and [Rules](https://ldaprecord.com/docs/laravel/v1/auth/configuration/#rules).

🔄  **Import & Synchronize LDAP users**

Import users from your directory via [command](https://ldaprecord.com/docs/laravel/v3/auth/database/importing): `php artisan ldap:import`.

💼  **Multi-Domain Support**

Authenticate users from as many LDAP domains as you'd like. Support comes [out of the box](https://ldaprecord.com/docs/laravel/v3/auth/multi-domain).

🎩  **Eloquent Query Builder**

Search for LDAP objects with a [fluent and easy to use interface](https://ldaprecord.com/docs/core/v3/searching) you're used to. You'll feel right at home.

✏️ **Active Record LDAP Models**

LDAP objects are [individual models](https://ldaprecord.com/docs/core/v3/models). Persist them to your LDAP server with a single `save()`.

💫  **LDAP Directory Emulator**

Test [authenticating](https://ldaprecord.com/docs/laravel/v3/auth/testing/#getting-started) and
[querying users](https://ldaprecord.com/docs/laravel/v3/testing/#getting-started) without
changing your application code.

Create, update, and delete LDAP objects without touching a real LDAP server.

---

<h3 align="center">LdapRecord-Laravel is Supportware™</h3>

<p align="center">If you require support using LdapRecord-Laravel, a <a href="https://github.com/sponsors/stevebauman">sponsorship</a> is required :pray:</p>

<p align="center">Thank you for your understanding :heart:</p>

--- 

<h3 align="center">Security Vulnerabilities</h3>

<p align="center">If you discover a security vulnerability within LdapRecord-Laravel, please send an e-mail to Steve Bauman via <a href="mailto:steven_bauman@outlook.com">steven_bauman@outlook.com</a>.</p>

<p align="center">All security vulnerabilities will be promptly addressed.</p>
