/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.contextmanager;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.contextmanager.ContextManagerConfig;

public class ContextManagementTemplate
implements ToXContentObject,
Writeable {
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String HOOKS_FIELD = "hooks";
    public static final String CREATED_TIME_FIELD = "created_time";
    public static final String LAST_MODIFIED_FIELD = "last_modified";
    public static final String CREATED_BY_FIELD = "created_by";
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[a-z0-9_-]{1,49}$");
    private String name;
    private String description;
    private Map<String, List<ContextManagerConfig>> hooks;
    private Instant createdTime;
    private Instant lastModified;
    private String createdBy;

    public ContextManagementTemplate(StreamInput input) throws IOException {
        this.name = input.readString();
        this.description = input.readOptionalString();
        int hooksSize = input.readInt();
        this.hooks = hooksSize >= 0 ? input.readMap(StreamInput::readString, in -> {
            try {
                int listSize = in.readInt();
                ArrayList<ContextManagerConfig> configs = new ArrayList<ContextManagerConfig>();
                for (int i = 0; i < listSize; ++i) {
                    configs.add(new ContextManagerConfig(in));
                }
                return configs;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }) : null;
        this.createdTime = input.readOptionalInstant();
        this.lastModified = input.readOptionalInstant();
        this.createdBy = input.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.description);
        if (this.hooks != null) {
            out.writeInt(this.hooks.size());
            out.writeMap(this.hooks, StreamOutput::writeString, (output, configs) -> {
                try {
                    output.writeInt(configs.size());
                    for (ContextManagerConfig config : configs) {
                        config.writeTo(output);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            out.writeInt(0);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastModified);
        out.writeOptionalString(this.createdBy);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.hooks != null && !this.hooks.isEmpty()) {
            builder.field(HOOKS_FIELD, this.hooks);
        }
        if (this.createdTime != null) {
            builder.field(CREATED_TIME_FIELD, this.createdTime.toEpochMilli());
        }
        if (this.lastModified != null) {
            builder.field(LAST_MODIFIED_FIELD, this.lastModified.toEpochMilli());
        }
        if (this.createdBy != null) {
            builder.field(CREATED_BY_FIELD, this.createdBy);
        }
        builder.endObject();
        return builder;
    }

    public static ContextManagementTemplate parse(XContentParser parser) throws IOException {
        String name = null;
        String description = null;
        Map<String, List<ContextManagerConfig>> hooks = null;
        Instant createdTime = null;
        Instant lastModified = null;
        String createdBy = null;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block16;
                }
                case "description": {
                    description = parser.text();
                    continue block16;
                }
                case "hooks": {
                    hooks = ContextManagementTemplate.parseHooks(parser);
                    continue block16;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block16;
                }
                case "last_modified": {
                    lastModified = Instant.ofEpochMilli(parser.longValue());
                    continue block16;
                }
                case "created_by": {
                    createdBy = parser.text();
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return ContextManagementTemplate.builder().name(name).description(description).hooks(hooks).createdTime(createdTime).lastModified(lastModified).createdBy(createdBy).build();
    }

    private static Map<String, List<ContextManagerConfig>> parseHooks(XContentParser parser) throws IOException {
        HashMap<String, List<ContextManagerConfig>> hooks = new HashMap<String, List<ContextManagerConfig>>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String hookName = parser.currentName();
            parser.nextToken();
            ArrayList<ContextManagerConfig> configs = new ArrayList<ContextManagerConfig>();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                configs.add(ContextManagerConfig.parse(parser));
            }
            hooks.put(hookName, configs);
        }
        return hooks;
    }

    public boolean isValid() {
        return this.isValidName() && this.isValidHooksAndConfigs();
    }

    public boolean isValidName() {
        return this.name != null && VALID_NAME_PATTERN.matcher(this.name).matches();
    }

    private boolean isValidHooksAndConfigs() {
        if (this.hooks != null) {
            if (this.hooks.isEmpty()) {
                return false;
            }
            for (List<ContextManagerConfig> configs : this.hooks.values()) {
                if (configs == null) continue;
                for (ContextManagerConfig config : configs) {
                    if (config.isValid()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Generated
    public static ContextManagementTemplateBuilder builder() {
        return new ContextManagementTemplateBuilder();
    }

    @Generated
    public ContextManagementTemplateBuilder toBuilder() {
        return new ContextManagementTemplateBuilder().name(this.name).description(this.description).hooks(this.hooks).createdTime(this.createdTime).lastModified(this.lastModified).createdBy(this.createdBy);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Map<String, List<ContextManagerConfig>> getHooks() {
        return this.hooks;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastModified() {
        return this.lastModified;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setHooks(Map<String, List<ContextManagerConfig>> hooks) {
        this.hooks = hooks;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setLastModified(Instant lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextManagementTemplate)) {
            return false;
        }
        ContextManagementTemplate other = (ContextManagementTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, List<ContextManagerConfig>> this$hooks = this.getHooks();
        Map<String, List<ContextManagerConfig>> other$hooks = other.getHooks();
        if (this$hooks == null ? other$hooks != null : !((Object)this$hooks).equals(other$hooks)) {
            return false;
        }
        Instant this$createdTime = this.getCreatedTime();
        Instant other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Instant this$lastModified = this.getLastModified();
        Instant other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        return !(this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContextManagementTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, List<ContextManagerConfig>> $hooks = this.getHooks();
        result = result * 59 + ($hooks == null ? 43 : ((Object)$hooks).hashCode());
        Instant $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Instant $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContextManagementTemplate(name=" + this.getName() + ", description=" + this.getDescription() + ", hooks=" + String.valueOf(this.getHooks()) + ", createdTime=" + String.valueOf(this.getCreatedTime()) + ", lastModified=" + String.valueOf(this.getLastModified()) + ", createdBy=" + this.getCreatedBy() + ")";
    }

    @Generated
    public ContextManagementTemplate() {
    }

    @Generated
    public ContextManagementTemplate(String name, String description, Map<String, List<ContextManagerConfig>> hooks, Instant createdTime, Instant lastModified, String createdBy) {
        this.name = name;
        this.description = description;
        this.hooks = hooks;
        this.createdTime = createdTime;
        this.lastModified = lastModified;
        this.createdBy = createdBy;
    }

    @Generated
    public static class ContextManagementTemplateBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private Map<String, List<ContextManagerConfig>> hooks;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastModified;
        @Generated
        private String createdBy;

        @Generated
        ContextManagementTemplateBuilder() {
        }

        @Generated
        public ContextManagementTemplateBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ContextManagementTemplateBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ContextManagementTemplateBuilder hooks(Map<String, List<ContextManagerConfig>> hooks) {
            this.hooks = hooks;
            return this;
        }

        @Generated
        public ContextManagementTemplateBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public ContextManagementTemplateBuilder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Generated
        public ContextManagementTemplateBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Generated
        public ContextManagementTemplate build() {
            return new ContextManagementTemplate(this.name, this.description, this.hooks, this.createdTime, this.lastModified, this.createdBy);
        }

        @Generated
        public String toString() {
            return "ContextManagementTemplate.ContextManagementTemplateBuilder(name=" + this.name + ", description=" + this.description + ", hooks=" + String.valueOf(this.hooks) + ", createdTime=" + String.valueOf(this.createdTime) + ", lastModified=" + String.valueOf(this.lastModified) + ", createdBy=" + this.createdBy + ")";
        }
    }
}

