/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.security.resources.ResourceAccessHandler;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.security.spi.resources.client.ResourceSharingClient;

public final class ResourceAccessControlClient
implements ResourceSharingClient {
    private static final Logger LOGGER = LogManager.getLogger(ResourceAccessControlClient.class);
    private final ResourceAccessHandler resourceAccessHandler;
    private final ResourcePluginInfo resourcePluginInfo;
    private final OpensearchDynamicSetting<List<String>> resourceSharingProtectedResourcesSetting;

    public ResourceAccessControlClient(ResourceAccessHandler resourceAccessHandler, ResourcePluginInfo resourcePluginInfo, OpensearchDynamicSetting<List<String>> resourceSharingProtectedResourcesSetting) {
        this.resourceAccessHandler = resourceAccessHandler;
        this.resourcePluginInfo = resourcePluginInfo;
        this.resourceSharingProtectedResourcesSetting = resourceSharingProtectedResourcesSetting;
    }

    public void verifyAccess(String resourceId, String resourceType, String action, ActionListener<Boolean> listener) {
        if (!this.isFeatureEnabledForType(resourceType)) {
            LOGGER.warn("Resource '{}' is onboarded to sharing framework but is not marked as protected. Action {} is allowed.", (Object)resourceId, (Object)action);
            listener.onResponse((Object)true);
            return;
        }
        this.resourceAccessHandler.hasPermission(resourceId, resourceType, action, listener);
    }

    public void getAccessibleResourceIds(String resourceType, ActionListener<Set<String>> listener) {
        this.resourceAccessHandler.getOwnAndSharedResourceIdsForCurrentUser(resourceType, listener);
    }

    public boolean isFeatureEnabledForType(String resourceType) {
        return this.resourceSharingProtectedResourcesSetting.getDynamicSettingValue().contains(resourceType);
    }
}

