/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor;

import java.net.SocketAddress;
import java.util.concurrent.Future;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.concurrent.FutureCallback;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.net.NamedEndpoint;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.ConnectionInitiator;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOReactorService;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOReactorShutdownException;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOReactorStatus;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOSession;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.SingleCoreIOReactor;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Args;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Timeout;

abstract class AbstractIOReactorBase
implements ConnectionInitiator,
IOReactorService {
    AbstractIOReactorBase() {
    }

    @Override
    public final Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) throws IOReactorShutdownException {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) > 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        try {
            SingleCoreIOReactor dispatcher = this.selectWorker();
            if (dispatcher.getStatus() == IOReactorStatus.SHUT_DOWN) {
                throw new IOReactorShutdownException("I/O reactor has been shut down");
            }
            return dispatcher.connect(remoteEndpoint, remoteAddress, localAddress, timeout, attachment, callback);
        }
        catch (IOReactorShutdownException ex) {
            this.initiateShutdown();
            throw ex;
        }
    }

    abstract SingleCoreIOReactor selectWorker();
}

