/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;

public class KeepLastNCommitsDeletionPolicy
extends IndexDeletionPolicy {
    private final int numCommitsToKeep;

    public KeepLastNCommitsDeletionPolicy(int numCommitsToKeep) {
        if (numCommitsToKeep <= 0) {
            throw new IllegalArgumentException("number of recent commits to keep must be positive");
        }
        this.numCommitsToKeep = numCommitsToKeep;
    }

    @Override
    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        this.onCommit(commits);
    }

    @Override
    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        int size = commits.size();
        for (int i = 0; i < size - this.numCommitsToKeep; ++i) {
            commits.get(i).delete();
        }
    }
}

