/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class DecomposeVectorNode extends ImplicitNode {

	public DecomposeVectorNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the input
	 *
	 * @return the input port for the vector to decompose
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputA() throws Lib3MFException {
		Pointer bufferA = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_decomposevectornode_getinputa.invokeInt(new java.lang.Object[]{mHandle, bufferA}));
		Pointer valueA = bufferA.getPointer(0);
		ImplicitPort a = null;
		if (valueA == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "A was a null pointer");
		}
		a = mWrapper.PolymorphicFactory(valueA, ImplicitPort.class);
		return a;
	}

	/**
	 * Retrieves the output for the x component
	 *
	 * @return the output for the x component
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputX() throws Lib3MFException {
		Pointer bufferX = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_decomposevectornode_getoutputx.invokeInt(new java.lang.Object[]{mHandle, bufferX}));
		Pointer valueX = bufferX.getPointer(0);
		ImplicitPort x = null;
		if (valueX == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "X was a null pointer");
		}
		x = mWrapper.PolymorphicFactory(valueX, ImplicitPort.class);
		return x;
	}

	/**
	 * Retrieves the output for the y component
	 *
	 * @return the output for the y component
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputY() throws Lib3MFException {
		Pointer bufferY = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_decomposevectornode_getoutputy.invokeInt(new java.lang.Object[]{mHandle, bufferY}));
		Pointer valueY = bufferY.getPointer(0);
		ImplicitPort y = null;
		if (valueY == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Y was a null pointer");
		}
		y = mWrapper.PolymorphicFactory(valueY, ImplicitPort.class);
		return y;
	}

	/**
	 * Retrieves the output for the z component
	 *
	 * @return the output for the z component
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputZ() throws Lib3MFException {
		Pointer bufferZ = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_decomposevectornode_getoutputz.invokeInt(new java.lang.Object[]{mHandle, bufferZ}));
		Pointer valueZ = bufferZ.getPointer(0);
		ImplicitPort z = null;
		if (valueZ == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Z was a null pointer");
		}
		z = mWrapper.PolymorphicFactory(valueZ, ImplicitPort.class);
		return z;
	}


}

