/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.JwkParsingUtils;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.consumer.HttpDataFetcher;
import org.keycloak.sdjwt.consumer.JwtVcMetadata;
import org.keycloak.sdjwt.consumer.TrustedSdJwtIssuer;

public class JwtVcMetadataTrustedSdJwtIssuer
implements TrustedSdJwtIssuer {
    private final Pattern issuerUriPattern;
    private final HttpDataFetcher httpDataFetcher;

    public JwtVcMetadataTrustedSdJwtIssuer(String issuerUri, HttpDataFetcher httpDataFetcher) {
        try {
            this.validateHttpsIssuerUri(issuerUri);
        }
        catch (VerificationException e) {
            throw new IllegalArgumentException(e);
        }
        this.issuerUriPattern = Pattern.compile(Pattern.quote(issuerUri));
        this.httpDataFetcher = httpDataFetcher;
    }

    public JwtVcMetadataTrustedSdJwtIssuer(Pattern issuerUriPattern, HttpDataFetcher httpDataFetcher) {
        this.issuerUriPattern = issuerUriPattern;
        this.httpDataFetcher = httpDataFetcher;
    }

    @Override
    public List<SignatureVerifierContext> resolveIssuerVerifyingKeys(IssuerSignedJWT issuerSignedJWT) throws VerificationException {
        String iss = Optional.ofNullable(issuerSignedJWT.getPayload().get("iss")).map(JsonNode::asText).orElse("");
        String kid = issuerSignedJWT.getJwsHeader().getKeyId();
        Matcher matcher = this.issuerUriPattern.matcher(iss);
        if (!matcher.matches()) {
            throw new VerificationException(String.format("Unexpected Issuer URI claim. Expected=/%s/, Got=%s", this.issuerUriPattern.pattern(), iss));
        }
        this.validateHttpsIssuerUri(iss);
        List<JWK> jwks = this.fetchIssuerMetadataJwks(iss);
        if (jwks.isEmpty()) {
            throw new VerificationException(String.format("Issuer JWKs were unexpectedly resolved to an empty list. Issuer URI: %s", iss));
        }
        if (kid != null) {
            List matchingJwks = jwks.stream().filter(jwk -> {
                String jwkKid = jwk.getKeyId();
                return jwkKid != null && jwkKid.equals(kid);
            }).collect(Collectors.toList());
            if (matchingJwks.isEmpty()) {
                throw new VerificationException(String.format("No published JWK was found to match kid: %s", kid));
            }
            if (matchingJwks.size() > 1) {
                throw new VerificationException(String.format("Cannot choose between multiple exposed JWKs with same kid: %s", kid));
            }
            jwks = Collections.singletonList((JWK)matchingJwks.get(0));
        }
        ArrayList<SignatureVerifierContext> verifiers = new ArrayList<SignatureVerifierContext>();
        for (JWK jwk2 : jwks) {
            try {
                verifiers.add(JwkParsingUtils.convertJwkToVerifierContext(jwk2));
            }
            catch (Exception e) {
                throw new VerificationException("A potential JWK was retrieved but found invalid", (Throwable)e);
            }
        }
        return verifiers;
    }

    private void validateHttpsIssuerUri(String issuerUri) throws VerificationException {
        if (!issuerUri.startsWith("https://")) {
            throw new VerificationException("HTTPS URI required to retrieve JWT VC Issuer Metadata");
        }
    }

    private List<JWK> fetchIssuerMetadataJwks(String issuerUri) throws VerificationException {
        JwtVcMetadata issuerMetadata;
        String normalizedIssuerUri = JwtVcMetadataTrustedSdJwtIssuer.normalizeUri(issuerUri);
        String jwtVcIssuerUri = JwtVcMetadataTrustedSdJwtIssuer.buildJwtVcIssuerMetadataUri(normalizedIssuerUri);
        JsonNode issuerMetadataNode = this.fetchData(jwtVcIssuerUri);
        try {
            issuerMetadata = (JwtVcMetadata)SdJwtUtils.mapper.treeToValue((TreeNode)issuerMetadataNode, JwtVcMetadata.class);
        }
        catch (JsonProcessingException e) {
            throw new VerificationException("Failed to parse exposed JWT VC Metadata", (Throwable)e);
        }
        String exposedIssuerUri = JwtVcMetadataTrustedSdJwtIssuer.normalizeUri(issuerMetadata.getIssuer());
        if (!normalizedIssuerUri.equals(exposedIssuerUri)) {
            throw new VerificationException(String.format("Unexpected metadata's issuer. Expected=%s, Got=%s", normalizedIssuerUri, exposedIssuerUri));
        }
        String jwksUri = issuerMetadata.getJwksUri();
        JSONWebKeySet jwks = issuerMetadata.getJwks();
        if (jwks == null && jwksUri != null) {
            JsonNode jwksNode = this.fetchData(jwksUri);
            try {
                jwks = (JSONWebKeySet)SdJwtUtils.mapper.treeToValue((TreeNode)jwksNode, JSONWebKeySet.class);
            }
            catch (JsonProcessingException e) {
                throw new VerificationException("Failed to parse exposed JWKS", (Throwable)e);
            }
        }
        if (jwks == null || jwks.getKeys() == null) {
            throw new VerificationException(String.format("Could not resolve issuer JWKs with URI: %s", issuerUri));
        }
        return Arrays.asList(jwks.getKeys());
    }

    static String buildJwtVcIssuerMetadataUri(String issuerUri) throws VerificationException {
        try {
            URI parsedIssuer = URI.create(issuerUri);
            String issuerPath = Optional.ofNullable(parsedIssuer.getRawPath()).orElse("");
            String metadataPath = "/.well-known/jwt-vc-issuer" + issuerPath;
            URI metadata = new URI(parsedIssuer.getScheme(), parsedIssuer.getAuthority(), metadataPath, null, null);
            return metadata.toString();
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            throw new VerificationException("Invalid issuer URI", (Throwable)ex);
        }
    }

    private JsonNode fetchData(String uri) throws VerificationException {
        try {
            return Objects.requireNonNull(this.httpDataFetcher.fetchJsonData(uri));
        }
        catch (Exception exception) {
            throw new VerificationException(String.format("Could not fetch data from URI: %s", uri), (Throwable)exception);
        }
    }

    private static String normalizeUri(String uri) {
        return uri.replaceAll("/$", "");
    }
}

