/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmTreatedJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.spi.NavigablePath;

public abstract class AbstractSqmJoin<L, R>
extends AbstractSqmFrom<L, R>
implements SqmJoin<L, R> {
    private final SqmJoinType joinType;
    private SqmPredicate onClausePredicate;

    public AbstractSqmJoin(NavigablePath navigablePath, SqmPathSource<R> referencedNavigable, SqmFrom<?, L> lhs, String alias, SqmJoinType joinType, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, lhs, alias, nodeBuilder);
        this.joinType = joinType;
    }

    @Override
    public SqmJoinType getSqmJoinType() {
        return this.joinType;
    }

    @Override
    public SqmPredicate getJoinPredicate() {
        return this.onClausePredicate;
    }

    @Override
    public void setJoinPredicate(SqmPredicate predicate) {
        if (log.isTraceEnabled()) {
            log.tracef("Setting join predicate [%s] (was [%s])", (Object)predicate.toString(), (Object)(this.onClausePredicate == null ? "<null>" : this.onClausePredicate.toString()));
        }
        this.onClausePredicate = predicate;
    }

    public void applyRestriction(SqmPredicate restriction) {
        this.onClausePredicate = this.onClausePredicate == null ? restriction : this.nodeBuilder().and(this.onClausePredicate, restriction);
    }

    @Override
    protected void copyTo(AbstractSqmJoin<L, R> target, SqmCopyContext context) {
        super.copyTo(target, context);
        target.onClausePredicate = this.onClausePredicate == null ? null : this.onClausePredicate.copy(context);
    }

    @Override
    public <S extends R> SqmTreatedJoin<L, R, S> treatAs(Class<S> treatTarget) {
        return this.treatAs((Class)treatTarget, (String)null);
    }

    @Override
    public <S extends R> SqmTreatedJoin<L, R, S> treatAs(EntityDomainType<S> treatTarget) {
        return this.treatAs((EntityDomainType)treatTarget, (String)null);
    }

    @Override
    public abstract <S extends R> SqmTreatedJoin<L, R, S> treatAs(Class<S> var1, String var2);

    @Override
    public abstract <S extends R> SqmTreatedJoin<L, R, S> treatAs(EntityDomainType<S> var1, String var2);

    @Override
    public abstract <S extends R> SqmTreatedJoin<L, R, S> treatAs(Class<S> var1, String var2, boolean var3);

    @Override
    public abstract <S extends R> SqmTreatedJoin<L, R, S> treatAs(EntityDomainType<S> var1, String var2, boolean var3);

    @Override
    public SqmFrom<?, L> getLhs() {
        return (SqmFrom)super.getLhs();
    }

    public SqmFrom<?, L> getParent() {
        return this.getLhs();
    }

    public JoinType getJoinType() {
        return this.joinType.getCorrespondingJpaJoinType();
    }

    @Override
    public SqmPredicate getOn() {
        return this.getJoinPredicate();
    }

    @Override
    public SqmJoin<L, R> on(JpaExpression<Boolean> restriction) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap(restriction));
        return this;
    }

    @Override
    public SqmJoin<L, R> on(Expression<Boolean> restriction) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap((Expression)restriction));
        return this;
    }

    @Override
    public SqmJoin<L, R> on(JpaPredicate ... restrictions) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap(restrictions));
        return this;
    }

    @Override
    public SqmJoin<L, R> on(Predicate ... restrictions) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap((Expression[])restrictions));
        return this;
    }

    @Override
    public <X> SqmEntityJoin<R, X> join(Class<X> targetEntityClass) {
        return super.join((Class)targetEntityClass, this.joinType);
    }

    @Override
    public <X> SqmEntityJoin<R, X> join(Class<X> targetEntityClass, SqmJoinType joinType) {
        return super.join((Class)targetEntityClass, joinType);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof AbstractSqmJoin && super.equals(object);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.joinType});
    }
}

