/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.grpc.client.GrpcClientOptions;
import java.util.Base64;
import java.util.Map;

public class GrpcClientOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, GrpcClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "maxMessageSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxMessageSize(((Number)member.getValue()).longValue());
                    break;
                }
                case "transportOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setTransportOptions(new HttpClientOptions((JsonObject)member.getValue()));
                }
            }
        }
    }

    static void toJson(GrpcClientOptions obj, JsonObject json) {
        GrpcClientOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(GrpcClientOptions obj, Map<String, Object> json) {
        json.put("maxMessageSize", obj.getMaxMessageSize());
        if (obj.getTransportOptions() != null) {
            json.put("transportOptions", obj.getTransportOptions().toJson());
        }
    }
}

