/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.MemberSubscription;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;

public class GroupSpecImpl
implements GroupSpec {
    private final Map<String, MemberSubscriptionAndAssignmentImpl> members;
    private final SubscriptionType subscriptionType;
    private final Map<Uuid, Map<Integer, String>> invertedMemberAssignment;
    private final Optional<Map<Uuid, Set<Integer>>> topicPartitionAllowedMap;

    public GroupSpecImpl(Map<String, MemberSubscriptionAndAssignmentImpl> members, SubscriptionType subscriptionType, Map<Uuid, Map<Integer, String>> invertedMemberAssignment) {
        this(members, subscriptionType, invertedMemberAssignment, Optional.empty());
    }

    public GroupSpecImpl(Map<String, MemberSubscriptionAndAssignmentImpl> members, SubscriptionType subscriptionType, Map<Uuid, Map<Integer, String>> invertedMemberAssignment, Optional<Map<Uuid, Set<Integer>>> topicPartitionAllowedMap) {
        this.members = Objects.requireNonNull(members);
        this.subscriptionType = Objects.requireNonNull(subscriptionType);
        this.invertedMemberAssignment = Objects.requireNonNull(invertedMemberAssignment);
        this.topicPartitionAllowedMap = Objects.requireNonNull(topicPartitionAllowedMap);
    }

    public Collection<String> memberIds() {
        return this.members.keySet();
    }

    public SubscriptionType subscriptionType() {
        return this.subscriptionType;
    }

    public boolean isPartitionAssigned(Uuid topicId, int partitionId) {
        Map<Integer, String> partitionMap = this.invertedMemberAssignment.get(topicId);
        if (partitionMap == null) {
            return false;
        }
        return partitionMap.containsKey(partitionId);
    }

    public boolean isPartitionAssignable(Uuid topicId, int partitionId) {
        return this.topicPartitionAllowedMap.map(allowedMap -> allowedMap.containsKey(topicId) && ((Set)allowedMap.get(topicId)).contains(partitionId)).orElse(true);
    }

    public MemberSubscription memberSubscription(String memberId) {
        MemberSubscription memberSubscription = this.members.get(memberId);
        if (memberSubscription == null) {
            throw new IllegalArgumentException("Member Id " + memberId + " not found.");
        }
        return memberSubscription;
    }

    public MemberAssignment memberAssignment(String memberId) {
        MemberSubscriptionAndAssignmentImpl member = this.members.get(memberId);
        if (member == null) {
            return new MemberAssignmentImpl(Map.of());
        }
        return member;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupSpecImpl)) {
            return false;
        }
        GroupSpecImpl groupSpec = (GroupSpecImpl)o;
        return Objects.equals(this.members, groupSpec.members) && this.subscriptionType == groupSpec.subscriptionType && Objects.equals(this.invertedMemberAssignment, groupSpec.invertedMemberAssignment) && Objects.equals(this.topicPartitionAllowedMap, groupSpec.topicPartitionAllowedMap);
    }

    public int hashCode() {
        return Objects.hash(this.members, this.subscriptionType, this.invertedMemberAssignment, this.topicPartitionAllowedMap);
    }

    public String toString() {
        return "GroupSpecImpl(members=" + String.valueOf(this.members) + ", subscriptionType=" + String.valueOf(this.subscriptionType) + ", invertedMemberAssignment=" + String.valueOf(this.invertedMemberAssignment) + ", topicPartitionAllowedMap=" + String.valueOf(this.topicPartitionAllowedMap) + ")";
    }
}

