/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.MaterializedStoreFactory;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.DslKeyValueParams;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.VersionedBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.VersionedKeyValueStoreBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStoreMaterializer<K, V>
extends MaterializedStoreFactory<K, V, KeyValueStore<Bytes, byte[]>> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueStoreMaterializer.class);

    public KeyValueStoreMaterializer(MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        super(materialized);
    }

    @Override
    public StoreBuilder<?> builder() {
        KeyValueBytesStoreSupplier supplier = this.materialized.storeSupplier() == null ? this.dslStoreSuppliers().keyValueStore(new DslKeyValueParams(this.materialized.storeName(), true)) : (KeyValueBytesStoreSupplier)this.materialized.storeSupplier();
        StoreBuilder<StateStore> builder = supplier instanceof VersionedBytesStoreSupplier ? Stores.versionedKeyValueStoreBuilder((VersionedBytesStoreSupplier)supplier, this.materialized.keySerde(), this.materialized.valueSerde()) : Stores.timestampedKeyValueStoreBuilder(supplier, this.materialized.keySerde(), this.materialized.valueSerde());
        if (this.materialized.loggingEnabled()) {
            builder.withLoggingEnabled(this.materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (this.materialized.cachingEnabled()) {
            if (!(builder instanceof VersionedKeyValueStoreBuilder)) {
                builder.withCachingEnabled();
            } else {
                LOG.info("Not enabling caching for store '{}' as versioned stores do not support caching.", (Object)supplier.name());
            }
        }
        return builder;
    }

    @Override
    public long retentionPeriod() {
        throw new IllegalStateException("retentionPeriod is not supported when not a window store");
    }

    @Override
    public long historyRetention() {
        if (!(this.materialized.storeSupplier() instanceof VersionedBytesStoreSupplier)) {
            throw new IllegalStateException("historyRetention is not supported when not a versioned store");
        }
        return ((VersionedBytesStoreSupplier)this.materialized.storeSupplier()).historyRetentionMs();
    }

    @Override
    public boolean isWindowStore() {
        return false;
    }

    @Override
    public boolean isVersionedStore() {
        return this.materialized.storeSupplier() instanceof VersionedBytesStoreSupplier;
    }
}

