/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.metrics;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsThreadMetricsDelegatingReporter
implements MetricsReporter {
    private static final Logger log = LoggerFactory.getLogger(StreamsThreadMetricsDelegatingReporter.class);
    private static final String THREAD_ID_TAG = "thread-id";
    private final Consumer<byte[], byte[]> consumer;
    private final String threadId;
    private final Optional<String> stateUpdaterThreadId;

    public StreamsThreadMetricsDelegatingReporter(Consumer<byte[], byte[]> consumer, String threadId, Optional<String> stateUpdaterThreadId) {
        this.consumer = Objects.requireNonNull(consumer);
        this.threadId = Objects.requireNonNull(threadId);
        this.stateUpdaterThreadId = stateUpdaterThreadId;
        log.debug("Creating MetricsReporter for threadId {} and stateUpdaterId {}", (Object)threadId, stateUpdaterThreadId);
    }

    public void init(List<KafkaMetric> metrics) {
        metrics.forEach(this::metricChange);
    }

    public void metricChange(KafkaMetric metric) {
        if (this.tagMatchStreamOrStateUpdaterThreadId(metric)) {
            log.debug("Registering metric {}", (Object)metric.metricName());
            this.consumer.registerMetricForSubscription(metric);
        }
    }

    private boolean tagMatchStreamOrStateUpdaterThreadId(KafkaMetric metric) {
        boolean shouldInclude;
        Map tags = metric.metricName().tags();
        boolean bl = shouldInclude = tags.containsKey(THREAD_ID_TAG) && (((String)tags.get(THREAD_ID_TAG)).equals(this.threadId) || Optional.ofNullable((String)tags.get(THREAD_ID_TAG)).equals(this.stateUpdaterThreadId));
        if (!shouldInclude) {
            log.trace("Rejecting metric {}", (Object)metric.metricName());
        }
        return shouldInclude;
    }

    public void metricRemoval(KafkaMetric metric) {
        if (this.tagMatchStreamOrStateUpdaterThreadId(metric)) {
            log.debug("Unregistering metric {}", (Object)metric.metricName());
            this.consumer.unregisterMetricFromSubscription(metric);
        }
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
    }
}

