/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jspecview.api.JSVPanel;
import jspecview.application.AboutDialog;
import jspecview.application.MainFrame;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.ScriptToken;

public class AppToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    protected MainFrame mainFrame;
    protected JSViewer vwr;
    JToggleButton gridToggleButton;
    JToggleButton coordsToggleButton;
    JToggleButton revPlotToggleButton;
    private JButton spectraButton;
    private JButton errorLogButton;
    private ImageIcon errorLogIcon;
    private ImageIcon errorLogYellowIcon;
    private ImageIcon errorLogRedIcon;

    public AppToolBar(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.vwr = mainFrame.vwr;
        this.jbInit();
    }

    void setSelections(JSVPanel jSVPanel) {
        if (jSVPanel != null) {
            PanelData panelData = jSVPanel.getPanelData();
            this.gridToggleButton.setSelected(panelData.getBoolean(ScriptToken.GRIDON));
            this.coordsToggleButton.setSelected(panelData.getBoolean(ScriptToken.COORDINATESON));
            this.revPlotToggleButton.setSelected(panelData.getBoolean(ScriptToken.REVERSEPLOT));
        }
    }

    void setMenuEnables(PanelNode panelNode) {
        if (panelNode == null) {
            return;
        }
        this.setSelections(panelNode.jsvp);
        this.spectraButton.setToolTipText("View Spectra");
    }

    void setError(boolean bl, boolean bl2) {
        this.errorLogButton.setIcon(bl2 ? this.errorLogYellowIcon : (bl ? this.errorLogRedIcon : this.errorLogIcon));
        this.errorLogButton.setEnabled(bl || bl2);
    }

    private void jbInit() {
        this.addButton(null, "Open", "open24", "open");
        this.addButton(null, "Print", "print24", "print");
        this.addSeparator();
        this.gridToggleButton = new JToggleButton();
        this.addButton(this.gridToggleButton, "Toggle Grid", "grid24", "GRIDON TOGGLE");
        this.coordsToggleButton = new JToggleButton();
        this.addButton(this.coordsToggleButton, "Toggle Coordinates", "coords24", "COORDINATESON TOGGLE");
        this.revPlotToggleButton = new JToggleButton();
        this.addButton(this.revPlotToggleButton, "Reverse Plot", "reverse24", "REVERSEPLOT TOGGLE");
        this.addSeparator();
        this.addButton(null, "Previous View", "previous24", "zoom previous");
        this.addButton(null, "Next View", "next24", "zoom next");
        this.addButton(null, "Reset", "reset24", "zoom out");
        this.addButton(null, "Clear Views", "clear24", "zoom clear");
        this.addSeparator();
        this.spectraButton = new JButton();
        this.addButton(this.spectraButton, "Overlay Display", "overlay24", "view");
        this.addSeparator();
        this.errorLogIcon = AppToolBar.getIcon("errorLog24");
        this.errorLogRedIcon = AppToolBar.getIcon("errorLogRed24");
        this.errorLogYellowIcon = AppToolBar.getIcon("errorLogYellow24");
        this.addButton(null, "Properties", "information24", "showProperties");
        this.errorLogButton = new JButton();
        this.addButton(this.errorLogButton, "Error Log", this.errorLogIcon, "SHOWERRORS");
        this.addSeparator();
        this.addButton(null, "About JSpecView", "about24", "about");
    }

    private static ImageIcon getIcon(Object object) {
        return new ImageIcon(AppToolBar.class.getResource("icons/" + object + ".gif"));
    }

    private AbstractButton addButton(AbstractButton abstractButton, String string, Object object, final String string2) {
        if (abstractButton == null) {
            abstractButton = new JButton();
        }
        if (object instanceof String) {
            object = AppToolBar.getIcon(object);
        }
        abstractButton.setBorder(null);
        abstractButton.setToolTipText(string);
        abstractButton.setIcon((ImageIcon)object);
        abstractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (string2.equals("open")) {
                    AppToolBar.this.vwr.openFileFromDialog(false, false, null, null);
                } else if (string2.equals("about")) {
                    new AboutDialog(AppToolBar.this.mainFrame);
                } else {
                    AppToolBar.this.vwr.runScript(string2);
                }
            }
        });
        this.add((Component)abstractButton, null);
        return abstractButton;
    }
}

