/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;

public class MopacGraphfReader
extends MopacSlaterReader {
    private int ac;
    private int nCoefficients;
    private float[][] invMatrix;
    private boolean isNewFormat;
    private Lst<float[]> orbitalData;
    private Lst<String> orbitalInfo;

    @Override
    protected void initializeReader() {
        this.alphaBeta = "alpha";
    }

    @Override
    protected boolean checkLine() throws Exception {
        this.readAtoms();
        if (this.doReadMolecularOrbitals) {
            this.readSlaterBasis();
            this.readMolecularOrbitals(false);
            if (this.readKeywords()) {
                this.readMolecularOrbitals(true);
            }
        }
        this.continuing = false;
        return false;
    }

    private void readAtoms() throws Exception {
        this.asc.newAtomSet();
        this.ac = this.parseIntStr(this.line);
        this.atomicNumbers = new int[this.ac];
        for (int i = 0; i < this.ac; ++i) {
            this.rd();
            this.atomicNumbers[i] = this.parseIntRange(this.line, 0, 4);
            Atom atom = this.asc.addNewAtom();
            this.setAtomCoordXYZ(atom, this.parseFloatRange(this.line, 4, 17), this.parseFloatRange(this.line, 17, 29), this.parseFloatRange(this.line, 29, 41));
            if (this.line.length() > 41) {
                atom.partialCharge = this.parseFloatStr(this.line.substring(41));
            }
            atom.elementSymbol = MopacGraphfReader.getElementSymbol(this.atomicNumbers[i]);
        }
    }

    private void readSlaterBasis() throws Exception {
        this.nCoefficients = 0;
        this.getSlaters();
        float[] values = new float[3];
        for (int iAtom = 0; iAtom < this.ac; ++iAtom) {
            MopacGraphfReader.getTokensFloat(this.rd(), values, 3);
            int atomicNumber = this.atomicNumbers[iAtom];
            this.createMopacSlaters(iAtom, atomicNumber, values, true);
        }
        this.nCoefficients = this.slaters.size();
        this.setSlaters(false);
    }

    private void readMolecularOrbitals(boolean isBeta) throws Exception {
        int iMo;
        if (isBeta) {
            this.alphaBeta = "beta";
        }
        float[][] list = null;
        if (this.rd() == null) {
            return;
        }
        boolean bl = this.isNewFormat = this.line.indexOf("ORBITAL") >= 0;
        if (this.isNewFormat) {
            this.orbitalData = new Lst();
            if (this.line.length() > 10) {
                this.orbitalInfo = new Lst();
            }
        } else {
            list = new float[this.nCoefficients][this.nCoefficients];
        }
        for (iMo = 0; iMo < this.nCoefficients; ++iMo) {
            float[] data;
            if (iMo != 0) {
                this.rd();
            }
            if (this.isNewFormat) {
                if (this.line == null || this.line.indexOf("ORBITAL") < 0 || this.line.indexOf("ORBITAL_LIST") >= 0) break;
                data = new float[this.nCoefficients];
                this.orbitalData.addLast(data);
                if (this.orbitalInfo != null) {
                    this.orbitalInfo.addLast(this.line);
                }
                this.rd();
            } else {
                data = list[iMo];
            }
            this.fillFloatArray(this.line, 15, data);
        }
        if (this.invMatrix == null) {
            if (this.isNewFormat && this.line.indexOf("MATRIX") < 0) {
                this.rd();
            }
            this.invMatrix = AU.newFloat2(this.nCoefficients);
            for (iMo = 0; iMo < this.nCoefficients; ++iMo) {
                this.invMatrix[iMo] = new float[iMo + 1];
                this.fillFloatArray(null, 15, this.invMatrix[iMo]);
            }
        }
        int n = this.nOrbitals = this.orbitalData == null ? this.nCoefficients : this.orbitalData.size();
        if (this.orbitalData != null) {
            list = AU.newFloat2(this.nOrbitals);
            int i = this.nOrbitals;
            while (--i >= 0) {
                list[i] = (float[])this.orbitalData.get(i);
            }
        }
        float[][] list2 = new float[this.nOrbitals][this.nCoefficients];
        for (int i = 0; i < this.nOrbitals; ++i) {
            for (int j = 0; j < this.nCoefficients; ++j) {
                for (int k = 0; k < this.nCoefficients; ++k) {
                    float[] fArray = list2[i];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + list[i][k] * (k >= j ? this.invMatrix[k][j] : this.invMatrix[j][k]);
                }
                if (!(Math.abs(list2[i][j]) < 1.0E-4f)) continue;
                list2[i][j] = 0.0f;
            }
        }
        if (this.isNewFormat && this.orbitalInfo == null && this.line != null && this.line.indexOf("ORBITAL_LIST") < 0) {
            this.rd();
        }
        float[] values = new float[2];
        for (int iMo2 = 0; iMo2 < this.nOrbitals; ++iMo2) {
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            if (this.orbitalInfo != null) {
                this.line = (String)this.orbitalInfo.get(iMo2);
                String[] tokens = this.getTokens();
                mo.put("energy", Float.valueOf(this.parseFloatStr(tokens[3])));
                mo.put("occupancy", Float.valueOf(this.parseFloatStr(tokens[1])));
            } else if (this.rd() != null) {
                MopacGraphfReader.getTokensFloat(this.line, values, 2);
                mo.put("energy", Float.valueOf(values[0]));
                mo.put("occupancy", Float.valueOf(values[1]));
            }
            mo.put("coefficients", list2[iMo2]);
            if (isBeta) {
                mo.put("type", "beta");
            }
            this.line = "\n";
            if (!this.filterMO()) continue;
            this.setMO(mo);
        }
        this.setMOs("eV");
    }

    private boolean readKeywords() throws Exception {
        boolean isUHF;
        if (this.rd() == null || this.line.indexOf(" Keywords:") < 0) {
            return false;
        }
        this.calculationType = this.line.substring(11).trim();
        this.moData.put("calculationType", this.calculationType);
        boolean bl = isUHF = this.line.indexOf("UHF") >= 0;
        if (isUHF) {
            int i = this.orbitals.size();
            while (--i >= 0) {
                ((Map)this.orbitals.get(i)).put("type", "alpha");
            }
        }
        return isUHF;
    }
}

