/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Isolate watershed basins using two seeds.


IsolatedWatershedImageFilter labels pixels with ReplaceValue1 that are in the same watershed basin
as Seed1 AND NOT the same as Seed2. The filter adjusts the waterlevel
until the two seeds are not in different basins. The user supplies a
Watershed threshold. The algorithm uses a binary search to adjust the
upper waterlevel, starting at UpperValueLimit. UpperValueLimit
defaults to the 1.0.
See:
 itk::simple::IsolatedWatershed for the procedural interface

 itk::IsolatedWatershedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIsolatedWatershedImageFilter.h
*/
public class IsolatedWatershedImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected IsolatedWatershedImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.IsolatedWatershedImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(IsolatedWatershedImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(IsolatedWatershedImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::IsolatedWatershedImageFilter::~IsolatedWatershedImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_IsolatedWatershedImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::IsolatedWatershedImageFilter::IsolatedWatershedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  IsolatedWatershedImageFilter() {
    this(SimpleITKJNI.new_IsolatedWatershedImageFilter(), true);
  }

  /**
Self&amp; itk::simple::IsolatedWatershedImageFilter::SetSeed1(std::vector&lt; uint32_t &gt; Seed1)

Set seed point 1. This seed will be isolated from Seed2 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue1.

*/
public  void setSeed1(VectorUInt32 Seed1) {
    SimpleITKJNI.IsolatedWatershedImageFilter_setSeed1(swigCPtr, this, VectorUInt32.getCPtr(Seed1), Seed1);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::IsolatedWatershedImageFilter::GetSeed1() const

Set seed point 1. This seed will be isolated from Seed2 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue1.

*/
public  VectorUInt32 getSeed1() {
    return new VectorUInt32(SimpleITKJNI.IsolatedWatershedImageFilter_getSeed1(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::IsolatedWatershedImageFilter::SetSeed2(std::vector&lt; uint32_t &gt; Seed2)

Set seed point 2. This seed will be isolated from Seed1 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue2.

*/
public  void setSeed2(VectorUInt32 Seed2) {
    SimpleITKJNI.IsolatedWatershedImageFilter_setSeed2(swigCPtr, this, VectorUInt32.getCPtr(Seed2), Seed2);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::IsolatedWatershedImageFilter::GetSeed2() const

Set seed point 2. This seed will be isolated from Seed1 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue2.

*/
public  VectorUInt32 getSeed2() {
    return new VectorUInt32(SimpleITKJNI.IsolatedWatershedImageFilter_getSeed2(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::IsolatedWatershedImageFilter::SetThreshold(double Threshold)

Set/Get the Watershed threshold. The default is 0.

*/
public  void setThreshold(double Threshold) {
    SimpleITKJNI.IsolatedWatershedImageFilter_setThreshold(swigCPtr, this, Threshold);
  }

  /**
double itk::simple::IsolatedWatershedImageFilter::GetThreshold() const

Set/Get the Watershed threshold. The default is 0.

*/
public  double getThreshold() {
    return SimpleITKJNI.IsolatedWatershedImageFilter_getThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsolatedWatershedImageFilter::SetUpperValueLimit(double UpperValueLimit)

Set/Get the limit on the upper waterlevel value. The default is 1.0.

*/
public  void setUpperValueLimit(double UpperValueLimit) {
    SimpleITKJNI.IsolatedWatershedImageFilter_setUpperValueLimit(swigCPtr, this, UpperValueLimit);
  }

  /**
double itk::simple::IsolatedWatershedImageFilter::GetUpperValueLimit() const

Set/Get the limit on the upper waterlevel value. The default is 1.0.

*/
public  double getUpperValueLimit() {
    return SimpleITKJNI.IsolatedWatershedImageFilter_getUpperValueLimit(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsolatedWatershedImageFilter::SetIsolatedValueTolerance(double IsolatedValueTolerance)

Set/Get the precision required for the intensity threshold value. The
default is .001.

*/
public  void setIsolatedValueTolerance(double IsolatedValueTolerance) {
    SimpleITKJNI.IsolatedWatershedImageFilter_setIsolatedValueTolerance(swigCPtr, this, IsolatedValueTolerance);
  }

  /**
double itk::simple::IsolatedWatershedImageFilter::GetIsolatedValueTolerance() const

Set/Get the precision required for the intensity threshold value. The
default is .001.

*/
public  double getIsolatedValueTolerance() {
    return SimpleITKJNI.IsolatedWatershedImageFilter_getIsolatedValueTolerance(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsolatedWatershedImageFilter::SetReplaceValue1(uint8_t ReplaceValue1)

Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).

*/
public  void setReplaceValue1(short ReplaceValue1) {
    SimpleITKJNI.IsolatedWatershedImageFilter_setReplaceValue1(swigCPtr, this, ReplaceValue1);
  }

  /**
uint8_t itk::simple::IsolatedWatershedImageFilter::GetReplaceValue1() const

Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).

*/
public  short getReplaceValue1() {
    return SimpleITKJNI.IsolatedWatershedImageFilter_getReplaceValue1(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsolatedWatershedImageFilter::SetReplaceValue2(uint8_t ReplaceValue2)

Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).

*/
public  void setReplaceValue2(short ReplaceValue2) {
    SimpleITKJNI.IsolatedWatershedImageFilter_setReplaceValue2(swigCPtr, this, ReplaceValue2);
  }

  /**
uint8_t itk::simple::IsolatedWatershedImageFilter::GetReplaceValue2() const

Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).

*/
public  short getReplaceValue2() {
    return SimpleITKJNI.IsolatedWatershedImageFilter_getReplaceValue2(swigCPtr, this);
  }

  /**
std::string itk::simple::IsolatedWatershedImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.IsolatedWatershedImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::IsolatedWatershedImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.IsolatedWatershedImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::IsolatedWatershedImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.IsolatedWatershedImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
