/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.freeplane.main.application.AuxiliarySplitPaneController;
import org.freeplane.main.application.AuxillaryEditorSplitPane;
import org.freeplane.view.swing.map.outline.MapAwareOutlinePane;

class AuxiliarySplitPanes {
    private final List<AuxillaryEditorSplitPane> panes;
    private final int numLevels;

    public AuxiliarySplitPanes(Component userContent) {
        this(userContent, 2);
    }

    public AuxiliarySplitPanes(Component userContent, int numLevels) {
        if (numLevels < 1) {
            throw new IllegalArgumentException("Number of levels must be at least 1, got: " + numLevels);
        }
        this.numLevels = numLevels;
        this.panes = new ArrayList<AuxillaryEditorSplitPane>(numLevels);
        Component currentMain = userContent;
        for (int level = 0; level < numLevels; ++level) {
            AuxiliarySplitPaneController controller = this.createControllerForLevel(level);
            AuxillaryEditorSplitPane pane = new AuxillaryEditorSplitPane(currentMain, controller);
            pane.setManager(this);
            this.panes.add(pane);
            currentMain = pane;
        }
        if (numLevels >= 2) {
            AuxillaryEditorSplitPane pane = this.getPane(1);
            MapAwareOutlinePane outlinePane = new MapAwareOutlinePane(pane);
            this.insertComponentIntoSplitPane(1, (JComponent)outlinePane, "outline");
            pane.bindAuxiliaryVisibilityToProperty("outlineVisible");
        }
    }

    private AuxiliarySplitPaneController createControllerForLevel(int level) {
        if (level == 0) {
            return new AuxiliarySplitPaneController("aux_split_pane_last_position", "note_location", true);
        }
        String positionKey = "aux_split_pane_level_" + level + "_position";
        String defaultLocation = level == 1 ? "right" : "bottom";
        return new AuxiliarySplitPaneController(positionKey, defaultLocation, false);
    }

    public AuxillaryEditorSplitPane getRootPane() {
        return this.panes.get(this.numLevels - 1);
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public void insertComponentIntoSplitPane(int level, JComponent component, String mode) {
        this.validateLevel(level);
        this.panes.get(level).insertComponentIntoSplitPane(component, mode);
    }

    public void changeAuxComponentSide(int level, String location) {
        this.validateLevel(level);
        this.panes.get(level).changeAuxComponentSide(location);
    }

    public void removeAuxiliaryComponent(int level) {
        this.validateLevel(level);
        this.panes.get(level).removeAuxiliaryComponent();
    }

    public JComponent getAuxiliaryComponent(int level) {
        this.validateLevel(level);
        return this.panes.get(level).getAuxiliaryComponent();
    }

    public AuxillaryEditorSplitPane getPane(int level) {
        this.validateLevel(level);
        return this.panes.get(level);
    }

    public void moveAuxiliaryNoteTo(AuxiliarySplitPanes target, String mode) {
        if (target == null) {
            return;
        }
        if (this.getNumLevels() < 1 || target.getNumLevels() < 1) {
            return;
        }
        AuxillaryEditorSplitPane fromPane = this.getPane(0);
        AuxillaryEditorSplitPane toPane = target.getPane(0);
        fromPane.moveAuxillaryComponentTo(toPane, mode);
    }

    private void validateLevel(int level) {
        if (level < 0 || level >= this.numLevels) {
            throw new IndexOutOfBoundsException("Level " + level + " is invalid. Valid range: 0 to " + (this.numLevels - 1));
        }
    }
}

