/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.archive.ZipEntryConstants;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.util.internal.GFileUtils;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class InPlaceClasspathBuilder
implements ClasspathBuilder {
    private static final int BUFFER_SIZE = 8192;

    @Override
    public void jar(File jarFile, ClasspathBuilder.Action action) {
        try {
            InPlaceClasspathBuilder.buildJar(jarFile, action);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Failed to create Jar file %s.", jarFile), (Throwable)e);
        }
    }

    private static void buildJar(File jarFile, ClasspathBuilder.Action action) throws IOException {
        Files.createDirectories(jarFile.getParentFile().toPath(), new FileAttribute[0]);
        try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(jarFile.toPath(), new OpenOption[0]), 8192));){
            outputStream.setLevel(0);
            action.execute(new ZipEntryBuilder(outputStream));
        }
    }

    @Override
    public void directory(File destinationDir, ClasspathBuilder.Action action) {
        try {
            InPlaceClasspathBuilder.buildDirectory(destinationDir, action);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Failed to create class directory %s.", destinationDir), (Throwable)e);
        }
    }

    private static void buildDirectory(File destinationDir, ClasspathBuilder.Action action) throws IOException {
        InPlaceClasspathBuilder.clearDirectory(destinationDir);
        Files.createDirectories(destinationDir.toPath(), new FileAttribute[0]);
        action.execute(new DirectoryEntryBuilder(destinationDir));
    }

    private static void clearDirectory(File dir) {
        if (!dir.exists()) {
            return;
        }
        Preconditions.checkArgument((boolean)dir.isDirectory(), (String)"Cannot clear contents of %s because it is not a directory", (Object)dir.getAbsolutePath());
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            GFileUtils.forceDelete((File)file);
        }
    }

    @NullMarked
    private static class ZipEntryBuilder
    implements ClasspathBuilder.EntryBuilder {
        private final ZipArchiveOutputStream outputStream;
        private final Set<String> dirs = new HashSet<String>();

        public ZipEntryBuilder(ZipArchiveOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void put(String name, byte[] content, ClasspathEntryVisitor.Entry.CompressionMethod compressionMethod) throws IOException {
            this.maybeAddParent(name);
            ZipArchiveEntry zipEntry = this.newZipEntryWithFixedTime(name);
            this.configureCompression(zipEntry, compressionMethod, content);
            this.outputStream.setEncoding("UTF-8");
            this.outputStream.putArchiveEntry(zipEntry);
            this.outputStream.write(content);
            this.outputStream.closeArchiveEntry();
        }

        private void maybeAddParent(String name) throws IOException {
            String dir = this.dir(name);
            if (dir != null && this.dirs.add(dir)) {
                this.maybeAddParent(dir);
                ZipArchiveEntry zipEntry = this.newZipEntryWithFixedTime(dir);
                this.outputStream.putArchiveEntry(zipEntry);
                this.outputStream.closeArchiveEntry();
            }
        }

        @Nullable String dir(String name) {
            int pos = name.lastIndexOf(47);
            if (pos == name.length() - 1) {
                pos = name.lastIndexOf(47, pos - 1);
            }
            if (pos >= 0) {
                return name.substring(0, pos + 1);
            }
            return null;
        }

        private ZipArchiveEntry newZipEntryWithFixedTime(String name) {
            ZipArchiveEntry entry = new ZipArchiveEntry(name);
            entry.setTime(ZipEntryConstants.CONSTANT_TIME_FOR_ZIP_ENTRIES);
            return entry;
        }

        private void configureCompression(ZipArchiveEntry entry, ClasspathEntryVisitor.Entry.CompressionMethod compressionMethod, byte[] contents) {
            if (ZipEntryBuilder.shouldCompress(compressionMethod)) {
                entry.setMethod(8);
            } else {
                entry.setMethod(0);
                entry.setSize((long)contents.length);
                entry.setCompressedSize((long)contents.length);
                entry.setCrc(ZipEntryBuilder.computeCrc32Of(contents));
            }
        }

        private static boolean shouldCompress(ClasspathEntryVisitor.Entry.CompressionMethod compressionMethod) {
            return compressionMethod != ClasspathEntryVisitor.Entry.CompressionMethod.STORED;
        }

        private static long computeCrc32Of(byte[] contents) {
            return Hashing.crc32().hashBytes(contents).padToLong();
        }
    }

    @NullMarked
    private static class DirectoryEntryBuilder
    implements ClasspathBuilder.EntryBuilder {
        private final File baseDir;

        public DirectoryEntryBuilder(File baseDir) {
            this.baseDir = baseDir;
        }

        @Override
        public void put(String name, byte[] content, ClasspathEntryVisitor.Entry.CompressionMethod compressionMethod) throws IOException {
            File target = new File(this.baseDir, name);
            if (target.exists()) {
                throw new IllegalArgumentException("Duplicate entry " + name);
            }
            Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
            Files.write(target.toPath(), content, StandardOpenOption.CREATE_NEW);
        }
    }
}

