\name{GrayscaleGeodesicDilateImageFilter}
\alias{GrayscaleGeodesicDilateImageFilter}
\title{GrayscaleGeodesicDilateImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Geodesic grayscale dilation of an image.
GrayscaleGeodesicDilateImageFilter}
\details{
Geodesic dilation operates on a "marker" image and a "mask" image.
The marker image is dilated using an elementary structuring element
(neighborhood of radius one using only the face connected neighbors).
The resulting image is then compared with the mask image. The output
image is the pixelwise minimum of the dilated marker image and the
mask image.
Geodesic dilation is run either one iteration or until convergence. In
the convergence case, the filter is equivalent to "reconstruction by
dilation". This filter is implemented to handle both scenarios. The
one iteration case is multi-threaded. The convergence case is
delegated to another instance of the same filter (but configured to
run a single iteration).
The marker image must be less than or equal to the mask image (on a
pixel by pixel basis).
Geodesic morphology is described in Chapter 6 of Pierre Soille's book
"Morphological Image Analysis: Principles and Applications", Second
Edition, Springer, 2003.
A noniterative version of this algorithm can be found in the ReconstructionByDilationImageFilter . This noniterative solution is much faster than the implementation
provided here. All ITK filters that previously used GrayscaleGeodesicDilateImageFilter as part of their implementation have been converted to use the ReconstructionByDilationImageFilter . The GrayscaleGeodesicDilateImageFilter is maintained for backward compatibility.
See:
MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter , ReconstructionByDilationImageFilter
GrayscaleGeodesicDilate for the procedural interface
itk::GrayscaleGeodesicDilateImageFilter for the Doxygen on the original ITK class.
GrayscaleGeodesicDilateImageFilter}
%C++ includes: sitkGrayscaleGeodesicDilateImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetRunOneIteration() const:}{
Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
"reconstruction by dilation". Default is off.
}
\item{ GrayscaleGeodesicDilateImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self RunOneIterationOff():}{}
\item{Self RunOneIterationOn():}{
Set the value of RunOneIteration to true or false respectfully.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetRunOneIteration(bool RunOneIteration):}{
Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
"reconstruction by dilation". Default is off.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GrayscaleGeodesicDilateImageFilter():}{
Destructor
}
}
}
