/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.injection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.util.lang.Args;

public class CompoundFieldValueFactory
implements IFieldValueFactory {
    private final List<IFieldValueFactory> delegates = new ArrayList<IFieldValueFactory>();

    public CompoundFieldValueFactory(IFieldValueFactory[] factories) {
        Args.notNull((Object)factories, (String)"factories");
        this.delegates.addAll(Arrays.asList(factories));
    }

    public CompoundFieldValueFactory(List<IFieldValueFactory> factories) {
        Args.notNull(factories, (String)"factories");
        this.delegates.addAll(factories);
    }

    public CompoundFieldValueFactory(IFieldValueFactory f1, IFieldValueFactory f2) {
        Args.notNull((Object)f1, (String)"f1");
        Args.notNull((Object)f2, (String)"f2");
        this.delegates.add(f1);
        this.delegates.add(f2);
    }

    public void addFactory(IFieldValueFactory factory) {
        Args.notNull((Object)factory, (String)"factory");
        this.delegates.add(factory);
    }

    @Override
    public Object getFieldValue(Field field, Object fieldOwner) {
        for (IFieldValueFactory factory : this.delegates) {
            Object object = factory.getFieldValue(field, fieldOwner);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public boolean supportsField(Field field) {
        for (IFieldValueFactory factory : this.delegates) {
            if (!factory.supportsField(field)) continue;
            return true;
        }
        return false;
    }
}

