/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.elasticsearch.core.search.Rescore;
import co.elastic.clients.elasticsearch.core.search.RescoreVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RescorerRetriever
extends RetrieverBase
implements RetrieverVariant {
    private final Retriever retriever;
    private final List<Rescore> rescore;
    public static final JsonpDeserializer<RescorerRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RescorerRetriever::setupRescorerRetrieverDeserializer);

    private RescorerRetriever(Builder builder) {
        super(builder);
        this.retriever = ApiTypeHelper.requireNonNull(builder.retriever, this, "retriever");
        this.rescore = ApiTypeHelper.unmodifiableRequired(builder.rescore, (Object)this, "rescore");
    }

    public static RescorerRetriever of(Function<Builder, ObjectBuilder<RescorerRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.Rescorer;
    }

    public final Retriever retriever() {
        return this.retriever;
    }

    public final List<Rescore> rescore() {
        return this.rescore;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("retriever");
        this.retriever.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.rescore)) {
            generator.writeKey("rescore");
            generator.writeStartArray();
            for (Rescore item0 : this.rescore) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRescorerRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::retriever, Retriever._DESERIALIZER, "retriever");
        op.add(Builder::rescore, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)Rescore._DESERIALIZER), "rescore");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RescorerRetriever> {
        private Retriever retriever;
        private List<Rescore> rescore;

        public final Builder retriever(Retriever value) {
            this.retriever = value;
            return this;
        }

        public final Builder retriever(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retriever(fn.apply(new Retriever.Builder()).build());
        }

        public final Builder retriever(RetrieverVariant value) {
            this.retriever = value._toRetriever();
            return this;
        }

        public final Builder rescore(List<Rescore> list) {
            this.rescore = Builder._listAddAll(this.rescore, list);
            return this;
        }

        public final Builder rescore(Rescore value, Rescore ... values) {
            this.rescore = Builder._listAdd(this.rescore, value, values);
            return this;
        }

        public final Builder rescore(RescoreVariant value, RescoreVariant ... values) {
            this.rescore = Builder._listAdd(this.rescore, value._toRescore(), new Rescore[0]);
            for (RescoreVariant v : values) {
                Builder._listAdd(this.rescore, v._toRescore(), new Rescore[0]);
            }
            return this;
        }

        public final Builder rescore(Function<Rescore.Builder, ObjectBuilder<Rescore>> fn) {
            return this.rescore(fn.apply(new Rescore.Builder()).build(), new Rescore[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RescorerRetriever build() {
            this._checkSingleUse();
            return new RescorerRetriever(this);
        }
    }
}

