/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.io.IOException;
import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Variable;

final class HYCOM {
    private static final Pattern DATE_PATTERN = Pattern.compile("days?\\s+as\\s+(?-i)%Y%m%d.*", 2);

    private HYCOM() {
    }

    static void convert(Decoder decoder, Variable[] variables) throws IOException, DataStoreException {
        Matcher matcher = null;
        for (Variable variable : variables) {
            String units;
            if (variable.getNumDimensions() != 1 || (units = variable.getUnitsString()) == null) continue;
            if (matcher == null) {
                matcher = DATE_PATTERN.matcher(units);
            } else {
                matcher.reset(units);
            }
            if (!matcher.matches()) continue;
            Dimension dimension = variable.getGridDimensions().get(0);
            Instant epoch = variable.setUnit(decoder.findVariable(dimension.getName()), Units.DAY);
            if (epoch == null) {
                epoch = Instant.EPOCH;
            }
            long origin = epoch.toEpochMilli();
            Vector values = variable.read();
            double[] times = new double[values.size()];
            GregorianCalendar calendar = new GregorianCalendar(decoder.getTimeZone(), Locale.US);
            calendar.clear();
            for (int i = 0; i < times.length; ++i) {
                double time = values.doubleValue(i);
                long date = (long)time;
                time -= (double)date;
                int day = (int)(date % 100L);
                int month = (int)((date /= 100L) % 100L);
                calendar.set(Math.toIntExact(date /= 100L), month - 1, day, 0, 0, 0);
                date = calendar.getTimeInMillis() - origin;
                times[i] = time += (double)date / 8.64E7;
            }
            variable.setValues(times);
        }
    }
}

