/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.tokens;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.tika.eval.core.tokens.AnalyzerDeserializer;

public class AnalyzerManager {
    private static final String GENERAL = "general";
    private static final String ALPHA_IDEOGRAPH = "alpha";
    private static final String COMMON_TOKENS = "common_tokens";
    private final Analyzer generalAnalyzer;
    private final Analyzer commonTokensAnalyzer;

    private AnalyzerManager(Analyzer generalAnalyzer, Analyzer commonTokensAnalyzer) {
        this.generalAnalyzer = generalAnalyzer;
        this.commonTokensAnalyzer = commonTokensAnalyzer;
    }

    public static AnalyzerManager newInstance(int maxTokens) {
        Map<String, Analyzer> map;
        try (InputStream is = AnalyzerManager.class.getClassLoader().getResourceAsStream("lucene-analyzers.json");
             InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            map = AnalyzerDeserializer.buildAnalyzers(reader, maxTokens);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't find lucene-analyzers.json?!");
        }
        Analyzer general = map.get(GENERAL);
        Analyzer alphaIdeo = map.get(ALPHA_IDEOGRAPH);
        Analyzer common = map.get(COMMON_TOKENS);
        if (general == null) {
            throw new IllegalStateException("Must specify general analyzer");
        }
        if (common == null) {
            throw new IllegalStateException("Must specify common_tokens analyzer");
        }
        return new AnalyzerManager(general, common);
    }

    public Analyzer getGeneralAnalyzer() {
        return this.generalAnalyzer;
    }

    public Analyzer getCommonTokensAnalyzer() {
        return this.commonTokensAnalyzer;
    }
}

