/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs.strawman;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class StrawManTikaAppDriver
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(StrawManTikaAppDriver.class);
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private final int totalThreads;
    private final int threadNum;
    private final Path inputRoot;
    private final Path outputRoot;
    private final Path fileList;
    private final String[] args;

    public StrawManTikaAppDriver(Path inputRoot, Path outputRoot, int totalThreads, Path fileList, String[] args) {
        this.inputRoot = inputRoot;
        this.outputRoot = outputRoot;
        this.fileList = fileList;
        this.args = args;
        this.threadNum = threadCount.getAndIncrement();
        this.totalThreads = totalThreads;
    }

    public static String usage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Example usage:\n");
        sb.append("java -cp <CP> org.apache.batch.fs.strawman.StrawManTikaAppDriver ");
        sb.append("<inputDir> <outputDir> <numThreads> ");
        sb.append("java -jar tika-app-X.Xjar <...commandline arguments for tika-app>\n\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        if (args.length < 6) {
            System.err.println(StrawManTikaAppDriver.usage());
        }
        Path inputDir = Paths.get(args[0], new String[0]);
        Path outputDir = Paths.get(args[1], new String[0]);
        int totalThreads = Integer.parseInt(args[2]);
        Path fileList = null;
        if (args.length > 3 && !Files.isReadable(fileList = Paths.get(args[3], new String[0]))) {
            fileList = null;
        }
        int initialParams = fileList == null ? 3 : 4;
        ArrayList<String> commandLine = new ArrayList<String>(Arrays.asList(args).subList(initialParams, args.length));
        totalThreads = Math.max(totalThreads, 1);
        ExecutorService ex = Executors.newFixedThreadPool(totalThreads);
        ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(ex);
        for (int i = 0; i < totalThreads; ++i) {
            StrawManTikaAppDriver driver = new StrawManTikaAppDriver(inputDir, outputDir, totalThreads, fileList, commandLine.toArray(new String[0]));
            completionService.submit(driver);
        }
        int totalFilesProcessed = 0;
        for (int i = 0; i < totalThreads; ++i) {
            try {
                Future future = completionService.take();
                if (future == null) continue;
                totalFilesProcessed += ((Integer)future.get()).intValue();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error(e.getMessage(), e);
            }
        }
        double elapsedSeconds = (double)(System.currentTimeMillis() - start) / 1000.0;
        LOG.info("Processed {} in {} seconds", (Object)totalFilesProcessed, (Object)elapsedSeconds);
        ex.shutdownNow();
    }

    @Override
    public Integer call() throws Exception {
        long start = System.currentTimeMillis();
        TikaVisitor v = new TikaVisitor();
        if (this.fileList != null) {
            TikaVisitor tikaVisitor = new TikaVisitor();
            try (BufferedReader reader = Files.newBufferedReader(this.fileList, StandardCharsets.UTF_8);){
                String line = reader.readLine();
                while (line != null) {
                    Path inputFile = this.inputRoot.resolve(line.trim());
                    if (Files.isReadable(inputFile)) {
                        try {
                            tikaVisitor.visitFile(inputFile, Files.readAttributes(inputFile, BasicFileAttributes.class, new LinkOption[0]));
                        }
                        catch (IOException e) {
                            LOG.warn("Problem with: " + String.valueOf(inputFile), e);
                        }
                    } else {
                        LOG.warn("Not readable: " + String.valueOf(inputFile));
                    }
                    line = reader.readLine();
                }
            }
        } else {
            Files.walkFileTree(this.inputRoot, v);
        }
        int processed = v.getProcessed();
        double elapsedSecs = ((double)System.currentTimeMillis() - (double)start) / 1000.0;
        LOG.info("Finished processing {} files in {} seconds.", (Object)processed, (Object)elapsedSecs);
        return processed;
    }

    private class TikaVisitor
    extends SimpleFileVisitor<Path> {
        private final AtomicInteger processed = new AtomicInteger(0);

        private TikaVisitor() {
        }

        int getProcessed() {
            return this.processed.get();
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            Process proc;
            int hashCode;
            if (StrawManTikaAppDriver.this.totalThreads > 1 && Math.abs((hashCode = file.toAbsolutePath().toString().hashCode()) % StrawManTikaAppDriver.this.totalThreads) != StrawManTikaAppDriver.this.threadNum) {
                return FileVisitResult.CONTINUE;
            }
            if (!file.startsWith(StrawManTikaAppDriver.this.inputRoot)) {
                LOG.warn("File (" + String.valueOf(file.toAbsolutePath()) + ") doesn't start with input root (" + String.valueOf(StrawManTikaAppDriver.this.inputRoot.toAbsolutePath()) + ")");
                return FileVisitResult.CONTINUE;
            }
            Path relPath = StrawManTikaAppDriver.this.inputRoot.relativize(file);
            String suffix = ".txt";
            ArrayList<String> commandLine = new ArrayList<String>();
            for (String arg : StrawManTikaAppDriver.this.args) {
                commandLine.add(arg);
                if (arg.equals("-J")) {
                    suffix = ".json";
                    continue;
                }
                if (!arg.contains("-x")) continue;
                suffix = ".html";
            }
            Object fullPath = file.toAbsolutePath().toString();
            if (((String)fullPath).contains(" ")) {
                fullPath = "\"" + (String)fullPath + "\"";
            }
            commandLine.add((String)fullPath);
            Path outputFile = Paths.get(StrawManTikaAppDriver.this.outputRoot.toAbsolutePath().toString(), relPath.toString() + suffix);
            try {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.error(MarkerFactory.getMarker("FATAL"), "parent directory for {} was not made!", (Object)outputFile);
                throw new RuntimeException("couldn't make parent file for " + String.valueOf(outputFile));
            }
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(commandLine);
            LOG.info("about to process: {}", (Object)file.toAbsolutePath());
            builder.redirectOutput(outputFile.toFile());
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            try {
                proc = builder.start();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), e);
                return FileVisitResult.CONTINUE;
            }
            boolean finished = false;
            long totalTime = 180000L;
            long pulse = 100L;
            int i = 0;
            while ((long)i < totalTime) {
                try {
                    Thread.sleep(pulse);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    int exit = proc.exitValue();
                    finished = true;
                    break;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    i = (int)((long)i + pulse);
                }
            }
            if (!finished) {
                LOG.warn("Had to terminate process working on: {}", (Object)file.toAbsolutePath());
                proc.destroyForcibly();
            }
            try {
                proc.getOutputStream().flush();
                proc.getOutputStream().close();
            }
            catch (IOException e) {
                LOG.warn("couldn't close process outputstream", e);
            }
            this.processed.incrementAndGet();
            return FileVisitResult.CONTINUE;
        }
    }
}

