/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.base;

import com.google.gxp.base.GxpAttrBundle;
import com.google.gxp.base.GxpContext;
import com.google.gxp.base.MarkupClosure;
import com.google.gxp.com.google.common.base.CharEscaper;
import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.i18n.Localizable;
import java.io.IOException;

public class MarkupAppender<T extends MarkupClosure> {
    public static final MarkupAppender<MarkupClosure> INSTANCE = new MarkupAppender();

    protected MarkupAppender() {
    }

    protected CharEscaper getCharEscaper(GxpContext gxpContext) {
        return CharEscapers.xmlEscaper();
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, byte value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, short value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, int value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, long value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, float value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, double value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, char value) throws IOException {
        this.getCharEscaper(gxpContext).escape(out).append(value);
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, T closure) throws IOException {
        Preconditions.checkNotNull(closure);
        closure.write(out, gxpContext);
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, GxpAttrBundle<T> bundle) throws IOException {
        Preconditions.checkNotNull(bundle);
        bundle.write(out, gxpContext);
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, Localizable value) throws IOException {
        Preconditions.checkNotNull(value);
        this.append(out, gxpContext, value.toString(gxpContext.getLocale()));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, CharSequence value) throws IOException {
        Preconditions.checkNotNull(value);
        this.getCharEscaper(gxpContext).escape(out).append(value);
        return out;
    }
}

