/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.metric.internal.MetricStatTimer;

public class CountStat {
    private final AtomicLong currentBucket;
    private final int tmSize;
    private final long[] tmBuckets;
    private final long[] tmTime;
    private final int thSize;
    private final long[] thBuckets;
    private final long[] thTime;
    private final int odSize;
    private final long[] odBuckets;
    private final long[] odTime;
    private final TimerTask task;
    private long bucketStart;
    private long exactExtra;
    private long allTime;

    public CountStat(int numBuckets) {
        this(numBuckets, -1L);
    }

    CountStat(int numBuckets, long startTime) {
        numBuckets = Math.max(numBuckets, 2);
        this.tmSize = 600000 / (numBuckets - 1);
        this.thSize = 10800000 / (numBuckets - 1);
        this.odSize = 86400000 / (numBuckets - 1);
        if (this.tmSize < 1 || this.thSize < 1 || this.odSize < 1) {
            throw new IllegalArgumentException("number of buckets is too large to be supported");
        }
        this.tmBuckets = new long[numBuckets];
        this.tmTime = new long[numBuckets];
        this.thBuckets = new long[numBuckets];
        this.thTime = new long[numBuckets];
        this.odBuckets = new long[numBuckets];
        this.odTime = new long[numBuckets];
        this.allTime = 0L;
        this.exactExtra = 0L;
        this.bucketStart = startTime >= 0L ? startTime : System.currentTimeMillis();
        this.currentBucket = new AtomicLong(0L);
        if (startTime < 0L) {
            this.task = new Fresher();
            MetricStatTimer.timer.scheduleAtFixedRate(this.task, this.tmSize, (long)this.tmSize);
        } else {
            this.task = null;
        }
    }

    public void incBy(long count) {
        this.currentBucket.addAndGet(count);
    }

    synchronized void rotateSched(long now) {
        long value = this.currentBucket.getAndSet(0L);
        long timeSpent = now - this.bucketStart;
        this.exactExtra += value;
        this.bucketStart = now;
        this.rotateBuckets(value, timeSpent);
    }

    synchronized void rotateBuckets(long value, long timeSpent) {
        this.rotate(value, timeSpent, this.tmSize, this.tmTime, this.tmBuckets);
        this.rotate(value, timeSpent, this.thSize, this.thTime, this.thBuckets);
        this.rotate(value, timeSpent, this.odSize, this.odTime, this.odBuckets);
        this.allTime += value;
    }

    private synchronized void rotate(long value, long timeSpent, long targetSize, long[] times, long[] buckets) {
        times[0] = times[0] + timeSpent;
        buckets[0] = buckets[0] + value;
        long currentTime = 0L;
        long currentVal = 0L;
        if (times[0] >= targetSize) {
            for (int i = 0; i < buckets.length; ++i) {
                long tmpTime = times[i];
                times[i] = currentTime;
                currentTime = tmpTime;
                long cnt = buckets[i];
                buckets[i] = currentVal;
                currentVal = cnt;
            }
        }
    }

    public synchronized Map<String, Long> getTimeCounts() {
        return this.getTimeCounts(System.currentTimeMillis());
    }

    synchronized Map<String, Long> getTimeCounts(long now) {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        long value = this.currentBucket.get();
        long timeSpent = now - this.bucketStart;
        ret.put("600", this.readApproximateTime(value, timeSpent, this.tmTime, this.tmBuckets, 600000L));
        ret.put("10800", this.readApproximateTime(value, timeSpent, this.thTime, this.thBuckets, 10800000L));
        ret.put("86400", this.readApproximateTime(value, timeSpent, this.odTime, this.odBuckets, 86400000L));
        ret.put(":all-time", value + this.allTime);
        return ret;
    }

    long readApproximateTime(long value, long timeSpent, long[] bucketTime, long[] buckets, long desiredTime) {
        long timeNeeded = desiredTime - timeSpent;
        long total = value;
        for (int i = 0; i < bucketTime.length; ++i) {
            if (timeNeeded < bucketTime[i]) {
                double pct = (double)timeNeeded / (double)bucketTime[i];
                total += (long)(pct * (double)buckets[i]);
                timeNeeded = 0L;
                break;
            }
            total += buckets[i];
            timeNeeded -= bucketTime[i];
        }
        return total;
    }

    public void close() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    private class Fresher
    extends TimerTask {
        private Fresher() {
        }

        @Override
        public void run() {
            CountStat.this.rotateSched(System.currentTimeMillis());
        }
    }
}

