/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TupleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TupleUtils.class);

    private TupleUtils() {
    }

    public static boolean isTick(Tuple tuple) {
        return tuple != null && "__system".equals(tuple.getSourceComponent()) && "__tick".equals(tuple.getSourceStreamId());
    }

    public static <T> int chooseTaskIndex(List<T> keys, int numTasks) {
        return Math.floorMod(TupleUtils.listHashCode(keys), numTasks);
    }

    private static <T> int listHashCode(List<T> alist) {
        if (alist == null) {
            return 1;
        }
        return Arrays.deepHashCode(alist.toArray());
    }

    public static Map<String, Object> putTickFrequencyIntoComponentConfig(Map<String, Object> conf, int tickFreqSecs) {
        if (conf == null) {
            conf = new Config();
        }
        if (tickFreqSecs > 0) {
            LOG.info("Enabling tick tuple with interval [{}]", (Object)tickFreqSecs);
            conf.put("topology.tick.tuple.freq.secs", tickFreqSecs);
        }
        return conf;
    }
}

