/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface BufferedMutator
extends Closeable {
    public static final String CLASSNAME_KEY = "hbase.client.bufferedmutator.classname";
    public static final long MIN_WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS = 100L;

    public TableName getName();

    public Configuration getConfiguration();

    public void mutate(Mutation var1) throws IOException;

    public void mutate(List<? extends Mutation> var1) throws IOException;

    @Override
    public void close() throws IOException;

    public void flush() throws IOException;

    default public void setWriteBufferPeriodicFlush(long timeoutMs) {
        this.setWriteBufferPeriodicFlush(timeoutMs, 1000L);
    }

    default public void setWriteBufferPeriodicFlush(long timeoutMs, long timerTickMs) {
        throw new UnsupportedOperationException("The BufferedMutator::setWriteBufferPeriodicFlush has not been implemented");
    }

    default public void disableWriteBufferPeriodicFlush() {
        this.setWriteBufferPeriodicFlush(0L, 100L);
    }

    default public long getWriteBufferPeriodicFlushTimeoutMs() {
        throw new UnsupportedOperationException("The BufferedMutator::getWriteBufferPeriodicFlushTimeoutMs has not been implemented");
    }

    default public long getWriteBufferPeriodicFlushTimerTickMs() {
        throw new UnsupportedOperationException("The BufferedMutator::getWriteBufferPeriodicFlushTimerTickMs has not been implemented");
    }

    default public long getWriteBufferSize() {
        throw new UnsupportedOperationException("The BufferedMutator::getWriteBufferSize has not been implemented");
    }

    default public void setRpcTimeout(int timeout) {
        throw new UnsupportedOperationException("The BufferedMutator::setRpcTimeout has not been implemented");
    }

    default public void setOperationTimeout(int timeout) {
        throw new UnsupportedOperationException("The BufferedMutator::setOperationTimeout has not been implemented");
    }

    default public Map<String, byte[]> getRequestAttributes() {
        return Collections.emptyMap();
    }

    default public int getMaxMutations() {
        throw new UnsupportedOperationException("The BufferedMutator::getMaxMutations has not been implemented");
    }

    @InterfaceAudience.Public
    public static interface ExceptionListener {
        public void onException(RetriesExhaustedWithDetailsException var1, BufferedMutator var2) throws RetriesExhaustedWithDetailsException;
    }
}

