/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.zookeeper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.StormTimer;
import org.apache.storm.nimbus.ILeaderElector;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.storm.shade.org.apache.curator.framework.recipes.leader.Participant;
import org.apache.storm.utils.Utils;
import org.apache.storm.zookeeper.LeaderListenerCallbackFactory;
import org.apache.storm.zookeeper.Zookeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectorImp
implements ILeaderElector {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderElectorImp.class);
    private final CuratorFramework zk;
    private final String leaderLockPath = "/leader-lock";
    private final String id;
    private final AtomicReference<LeaderLatch> leaderLatch;
    private final LeaderListenerCallbackFactory leaderListenerCallbackFactory;
    private final StormTimer timer;

    public LeaderElectorImp(CuratorFramework zk, String id, LeaderListenerCallbackFactory leaderListenerCallbackFactory) {
        this.zk = zk;
        this.id = id;
        this.leaderLatch = new AtomicReference<LeaderLatch>(new LeaderLatch(zk, "/leader-lock", id));
        this.leaderListenerCallbackFactory = leaderListenerCallbackFactory;
        this.timer = new StormTimer("leader-elector-timer", Utils.createDefaultUncaughtExceptionHandler());
    }

    public void prepare(Map<String, Object> conf) {
    }

    public void addToLeaderLockQueue() throws Exception {
        if (LeaderLatch.State.CLOSED.equals((Object)this.leaderLatch.get().getState())) {
            LeaderLatch latch = new LeaderLatch(this.zk, "/leader-lock", this.id);
            latch.addListener(this.leaderListenerCallbackFactory.create(this));
            latch.start();
            this.leaderLatch.set(latch);
            LOG.info("LeaderLatch was in closed state. Reset the leaderLatch, and queued for leader lock.");
        }
        if (LeaderLatch.State.LATENT.equals((Object)this.leaderLatch.get().getState())) {
            this.leaderLatch.get().addListener(this.leaderListenerCallbackFactory.create(this));
            this.leaderLatch.get().start();
            LOG.info("Queued up for leader lock.");
        } else {
            LOG.info("Node already in queue for leader lock.");
        }
    }

    public void quitElectionFor(int delayMs) throws Exception {
        this.removeFromLeaderLockQueue();
        this.timer.schedule(delayMs, () -> {
            try {
                this.addToLeaderLockQueue();
            }
            catch (Exception e) {
                throw Utils.wrapInRuntime((Exception)e);
            }
        }, false, 0);
    }

    private void removeFromLeaderLockQueue() throws Exception {
        if (LeaderLatch.State.STARTED.equals((Object)this.leaderLatch.get().getState())) {
            this.leaderLatch.get().close();
            LOG.info("Removed from leader lock queue.");
        } else {
            LOG.info("Leader latch is not started so no removeFromLeaderLockQueue needed.");
        }
    }

    public boolean isLeader() throws Exception {
        return this.leaderLatch.get().hasLeadership();
    }

    @VisibleForTesting
    public boolean awaitLeadership(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.leaderLatch.get().await(timeout, timeUnit);
    }

    public NimbusInfo getLeader() {
        try {
            return Zookeeper.toNimbusInfo(this.leaderLatch.get().getLeader());
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime((Exception)e);
        }
    }

    public List<NimbusInfo> getAllNimbuses() throws Exception {
        ArrayList<NimbusInfo> nimbusInfos = new ArrayList<NimbusInfo>();
        Collection participants = this.leaderLatch.get().getParticipants();
        for (Participant participant : participants) {
            nimbusInfos.add(Zookeeper.toNimbusInfo(participant));
        }
        return nimbusInfos;
    }

    public void close() throws Exception {
        this.timer.close();
        this.removeFromLeaderLockQueue();
    }
}

