/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RasNode;
import org.apache.storm.scheduler.resource.SchedulingResult;
import org.apache.storm.scheduler.resource.SchedulingStatus;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingSearcherState {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulingSearcherState.class);
    final long startTimeMillis;
    private final long maxEndTimeMs;
    private final Map<WorkerSlot, Map<String, Integer>> workerCompAssignmentCnts;
    private final boolean[] okToRemoveFromWorker;
    private final Map<RasNode, Map<String, Integer>> nodeCompAssignmentCnts;
    private final boolean[] okToRemoveFromNode;
    private List<ExecutorDetails> execs;
    private final int maxStatesSearched;
    private final TopologyDetails td;
    private final String topoName;
    private int statesSearched = 0;
    private int numBacktrack = 0;
    private int execIndex = 0;
    private final Map<ExecutorDetails, String> execToComp;
    private boolean oneExecutorPerWorker;
    private boolean oneComponentPerWorker;
    private int ackersPerWorker;
    private LinkedList<ExecutorDetails> unassignedAckers;
    private Set<ExecutorDetails> boundAckers;
    private Map<WorkerSlot, List<ExecutorDetails>> workerSlotToBoundAckers;
    private Set<ExecutorDetails> execsWithBoundAckers;

    public SchedulingSearcherState(Map<WorkerSlot, Map<String, Integer>> workerCompAssignmentCnts, Map<RasNode, Map<String, Integer>> nodeCompAssignmentCnts, int maxStatesSearched, long maxTimeMs, List<ExecutorDetails> execs, LinkedList<ExecutorDetails> unassignedAckers, TopologyDetails td, Map<ExecutorDetails, String> execToComp) {
        assert (execs != null);
        this.workerCompAssignmentCnts = workerCompAssignmentCnts;
        this.nodeCompAssignmentCnts = nodeCompAssignmentCnts;
        this.maxStatesSearched = maxStatesSearched;
        this.execs = execs;
        this.okToRemoveFromWorker = new boolean[execs.size()];
        this.okToRemoveFromNode = new boolean[execs.size()];
        this.td = td;
        this.topoName = td.getName();
        this.startTimeMillis = Time.currentTimeMillis();
        this.maxEndTimeMs = maxTimeMs <= 0L ? Long.MAX_VALUE : this.startTimeMillis + maxTimeMs;
        this.execToComp = execToComp;
        this.oneExecutorPerWorker = ObjectReader.getBoolean((Object)td.getConf().get("topology.ras.one.executor.per.worker"), (boolean)false);
        this.oneComponentPerWorker = ObjectReader.getBoolean((Object)td.getConf().get("topology.ras.one.component.per.worker"), (boolean)false);
        this.unassignedAckers = unassignedAckers;
        this.boundAckers = new HashSet<ExecutorDetails>();
        this.ackersPerWorker = ObjectReader.getInt((Object)td.getConf().get("topology.ras.acker.executors.per.worker"), (Integer)1);
        this.workerSlotToBoundAckers = new HashMap<WorkerSlot, List<ExecutorDetails>>();
        this.execsWithBoundAckers = new HashSet<ExecutorDetails>();
    }

    public void setSortedExecs(List<ExecutorDetails> sortedExecs) {
        if (this.execs != null && !new HashSet<ExecutorDetails>(this.execs).equals(new HashSet<ExecutorDetails>(sortedExecs))) {
            String err = String.format("executors in sorted list (cnt=%d) are different from initial assignment (cnt=%d), topo=%s)", sortedExecs.size(), this.execs.size(), this.topoName);
            throw new IllegalArgumentException(err);
        }
        this.execs = sortedExecs;
    }

    public void incStatesSearched() {
        ++this.statesSearched;
        if (this.statesSearched % 1000 == 0) {
            LOG.debug("Topology {} States Searched: {}", (Object)this.topoName, (Object)this.statesSearched);
            LOG.debug("Topology {} backtrack: {}", (Object)this.topoName, (Object)this.numBacktrack);
        }
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public int getStatesSearched() {
        return this.statesSearched;
    }

    public int getExecSize() {
        return this.execs.size();
    }

    public int getNumBacktrack() {
        return this.numBacktrack;
    }

    public int getExecIndex() {
        return this.execIndex;
    }

    public LinkedList<ExecutorDetails> getUnassignedAckers() {
        return this.unassignedAckers;
    }

    public ExecutorDetails peekUnassignedAckers() {
        return this.unassignedAckers.peek();
    }

    public Set<ExecutorDetails> getBoundAckers() {
        return this.boundAckers;
    }

    public Set<ExecutorDetails> getExecsWithBoundAckers() {
        return this.execsWithBoundAckers;
    }

    public boolean areSearchLimitsExceeded() {
        return this.statesSearched > this.maxStatesSearched || Time.currentTimeMillis() > this.maxEndTimeMs;
    }

    public SchedulingSearcherState nextExecutor() {
        ++this.execIndex;
        if (this.execIndex >= this.execs.size()) {
            String err = String.format("Internal Error: topology %s: execIndex exceeded limit %d >= %d", this.topoName, this.execIndex, this.execs.size());
            throw new IllegalStateException(err);
        }
        return this;
    }

    public boolean areAllExecsScheduled() {
        return this.execIndex == this.execs.size() - 1;
    }

    public ExecutorDetails currentExec() {
        return this.execs.get(this.execIndex);
    }

    public void assignCurrentExecutor(Map<ExecutorDetails, String> execToComp, RasNode node, WorkerSlot workerSlot) {
        ExecutorDetails exec = this.currentExec();
        String comp = execToComp.get(exec);
        LOG.trace("Topology {} Trying assignment of {} {} to {}", new Object[]{this.topoName, exec, comp, workerSlot});
        Map compToAssignmentCount = this.workerCompAssignmentCnts.computeIfAbsent(workerSlot, k -> new HashMap());
        compToAssignmentCount.put(comp, compToAssignmentCount.getOrDefault(comp, 0) + 1);
        this.okToRemoveFromWorker[this.execIndex] = true;
        Map nodeToAssignmentCount = this.nodeCompAssignmentCnts.computeIfAbsent(node, k -> new HashMap());
        nodeToAssignmentCount.put(comp, nodeToAssignmentCount.getOrDefault(comp, 0) + 1);
        this.okToRemoveFromNode[this.execIndex] = true;
        node.assignSingleExecutor(workerSlot, exec, this.td);
    }

    public int getNumOfAckersToBind(ExecutorDetails exec, WorkerSlot workerSlot) {
        if (!(this.oneExecutorPerWorker || this.oneComponentPerWorker || this.execToComp.get(exec).equals("__acker") || this.workerSlotToBoundAckers.containsKey(workerSlot))) {
            double ackerOnHeapReq;
            if (this.unassignedAckers.isEmpty()) {
                return 0;
            }
            double workerMaxHeapLimit = ObjectReader.getDouble((Object)this.td.getConf().get("topology.worker.max.heap.size.mb"));
            double workerHeapSpace = workerMaxHeapLimit - this.td.getTotalResources(exec).getOnHeapMemoryMb();
            int maxBoundAckers = (int)Math.floor(workerHeapSpace / (ackerOnHeapReq = this.td.getTotalResources(this.unassignedAckers.peek()).getOnHeapMemoryMb()));
            if (maxBoundAckers < this.ackersPerWorker) {
                LOG.debug("For exec {}, can only bind up to {} ackers due to {} limit. Acker Per worker setting: {}.", new Object[]{exec, maxBoundAckers, "topology.worker.max.heap.size.mb", this.ackersPerWorker});
            }
            int ret = Math.min(Math.min(maxBoundAckers, this.unassignedAckers.size()), this.ackersPerWorker);
            return ret;
        }
        return 0;
    }

    public void backtrack(Map<ExecutorDetails, String> execToComp, RasNode[] nodesForExec, WorkerSlot[] workerSlotForExec) {
        --this.execIndex;
        while (this.execIndex >= 0 && this.boundAckers.contains(this.execs.get(this.execIndex))) {
            --this.execIndex;
        }
        if (this.execIndex < 0) {
            throw new IllegalStateException("Internal Error: Topology " + this.topoName + " exec index became negative");
        }
        ++this.numBacktrack;
        ExecutorDetails exec = this.currentExec();
        String comp = execToComp.get(exec);
        RasNode node = nodesForExec[this.execIndex];
        WorkerSlot workerSlot = workerSlotForExec[this.execIndex];
        LOG.trace("Topology {} Backtracking {} {} from {}", new Object[]{this.topoName, exec, comp, workerSlot});
        if (this.okToRemoveFromWorker[this.execIndex]) {
            Map<String, Integer> compToAssignmentCount = this.workerCompAssignmentCnts.get(workerSlot);
            compToAssignmentCount.put(comp, compToAssignmentCount.getOrDefault(comp, 0) - 1);
            if (compToAssignmentCount.get(comp) == 0) {
                compToAssignmentCount.remove(comp);
            }
            this.okToRemoveFromWorker[this.execIndex] = false;
        }
        if (this.okToRemoveFromNode[this.execIndex]) {
            Map<String, Integer> nodeToAssignmentCount = this.nodeCompAssignmentCnts.get(node);
            nodeToAssignmentCount.put(comp, nodeToAssignmentCount.getOrDefault(comp, 0) - 1);
            if (nodeToAssignmentCount.get(comp) == 0) {
                nodeToAssignmentCount.remove(comp);
            }
            this.okToRemoveFromNode[this.execIndex] = false;
        }
        node.freeSingleExecutor(exec, this.td);
        if (this.execsWithBoundAckers.remove(exec) && this.workerSlotToBoundAckers.containsKey(workerSlot)) {
            this.freeWorkerSlotWithBoundAckers(node, workerSlot);
        }
    }

    public void assignSingleBoundAcker(RasNode node, WorkerSlot workerSlot) {
        if (this.unassignedAckers.isEmpty()) {
            String msg = String.format("No more available ackers to assign for the new worker: %s of topology: %s", workerSlot, this.topoName);
            throw new IllegalStateException(msg);
        }
        ExecutorDetails acker = this.unassignedAckers.removeFirst();
        node.assignSingleExecutor(workerSlot, acker, this.td);
        if (!this.workerSlotToBoundAckers.containsKey(workerSlot)) {
            this.workerSlotToBoundAckers.put(workerSlot, new ArrayList());
        }
        this.workerSlotToBoundAckers.get(workerSlot).add(acker);
        this.boundAckers.add(acker);
        String ackerCompId = "__acker";
        Map compToAssignmentCount = this.workerCompAssignmentCnts.computeIfAbsent(workerSlot, k -> new HashMap());
        compToAssignmentCount.put(ackerCompId, compToAssignmentCount.getOrDefault(ackerCompId, 0) + 1);
        Map nodeToAssignmentCount = this.nodeCompAssignmentCnts.computeIfAbsent(node, k -> new HashMap());
        nodeToAssignmentCount.put(ackerCompId, nodeToAssignmentCount.getOrDefault(ackerCompId, 0) + 1);
    }

    public void freeWorkerSlotWithBoundAckers(RasNode node, WorkerSlot workerSlot) {
        List<ExecutorDetails> ackers = this.workerSlotToBoundAckers.get(workerSlot);
        String ackerCompId = "__acker";
        if (ackers != null && !ackers.isEmpty()) {
            for (int i = ackers.size() - 1; i >= 0; --i) {
                ExecutorDetails acker = ackers.get(i);
                this.boundAckers.remove(acker);
                this.unassignedAckers.addFirst(acker);
                Map<String, Integer> compToAssignmentCount = this.workerCompAssignmentCnts.get(workerSlot);
                compToAssignmentCount.put(ackerCompId, compToAssignmentCount.getOrDefault(ackerCompId, 0) - 1);
                if (compToAssignmentCount.get(ackerCompId) == 0) {
                    compToAssignmentCount.remove(ackerCompId);
                }
                Map<String, Integer> nodeToAssignmentCount = this.nodeCompAssignmentCnts.get(node);
                nodeToAssignmentCount.put(ackerCompId, nodeToAssignmentCount.getOrDefault(ackerCompId, 0) - 1);
                if (nodeToAssignmentCount.get(ackerCompId) != 0) continue;
                nodeToAssignmentCount.remove(ackerCompId);
            }
            this.workerSlotToBoundAckers.remove(workerSlot);
            node.free(workerSlot);
        }
    }

    public void logNodeCompAssignments() {
        if (this.nodeCompAssignmentCnts == null || this.nodeCompAssignmentCnts.isEmpty()) {
            LOG.info("Topology {} NodeCompAssignment is empty", (Object)this.topoName);
            return;
        }
        StringBuffer sb = new StringBuffer();
        int cntAllNodes = 0;
        int cntFilledNodes = 0;
        for (RasNode node : new TreeSet<RasNode>(this.nodeCompAssignmentCnts.keySet())) {
            ++cntAllNodes;
            Map<String, Integer> oneMap = this.nodeCompAssignmentCnts.get(node);
            if (oneMap.isEmpty()) continue;
            String oneMapJoined = oneMap.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.joining(","));
            sb.append(String.format("\n\t(%d) Node %s: %s", ++cntFilledNodes, node.getId(), oneMapJoined));
        }
        LOG.info("Topology {} NodeCompAssignments available for {} of {} nodes {}", new Object[]{this.topoName, cntFilledNodes, cntAllNodes, sb});
        LOG.info("Topology {} Executors assignments attempted (cnt={}) are: \n\t{}", new Object[]{this.topoName, this.execs.size(), this.execs.stream().map(ExecutorDetails::toString).collect(Collectors.joining(","))});
    }

    public Map<String, Integer> getCompAssignmentCntMapForWorker(WorkerSlot workerSlot) {
        return this.workerCompAssignmentCnts.get(workerSlot);
    }

    public int getComponentCntOnNode(RasNode rasNode, String comp) {
        Map<String, Integer> map = this.nodeCompAssignmentCnts.get(rasNode);
        if (map == null) {
            return 0;
        }
        return map.getOrDefault(comp, 0);
    }

    public SchedulingResult createSchedulingResult(boolean success, String schedulerClassSimpleName) {
        if (success) {
            String msg = String.format("Fully Scheduled by %s (%d states traversed in %d ms, backtracked %d times)", schedulerClassSimpleName, this.getStatesSearched(), Time.currentTimeMillis() - this.getStartTimeMillis(), this.getNumBacktrack());
            return SchedulingResult.success(msg);
        }
        String msg = String.format("Cannot schedule by %s (%d states traversed in %d ms, backtracked %d times, %d of %d executors scheduled)", schedulerClassSimpleName, this.getStatesSearched(), Time.currentTimeMillis() - this.getStartTimeMillis(), this.getNumBacktrack(), this.getExecIndex(), this.getExecSize());
        this.logNodeCompAssignments();
        return SchedulingResult.failure(SchedulingStatus.FAIL_NOT_ENOUGH_RESOURCES, msg);
    }

    public boolean isExecCompDifferentFromPrior() {
        if (this.execIndex == 0) {
            return true;
        }
        return this.execToComp.getOrDefault(this.execs.get(this.execIndex), "").equals(this.execToComp.getOrDefault(this.execs.get(this.execIndex - 1), ""));
    }
}

