/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;

public class SupervisorResources {
    private final double totalMem;
    private final double totalCpu;
    private final double usedMem;
    private final double usedCpu;
    private Map<String, Double> totalGenericResources;
    private Map<String, Double> usedGenericResources;

    public SupervisorResources(double totalMem, double totalCpu, Map<String, Double> totalGenericResources, double usedMem, double usedCpu, Map<String, Double> usedGenericResources) {
        this.totalMem = totalMem;
        this.totalCpu = totalCpu;
        this.usedMem = usedMem;
        this.usedCpu = usedCpu;
        this.totalGenericResources = totalGenericResources != null ? totalGenericResources : new HashMap();
        this.usedGenericResources = usedGenericResources != null ? usedGenericResources : new HashMap();
    }

    public double getUsedMem() {
        return this.usedMem;
    }

    public double getUsedCpu() {
        return this.usedCpu;
    }

    public double getTotalMem() {
        return this.totalMem;
    }

    public double getTotalCpu() {
        return this.totalCpu;
    }

    public double getAvailableCpu() {
        return this.totalCpu - this.usedCpu;
    }

    public double getAvailableMem() {
        return this.totalMem - this.usedMem;
    }

    public Map<String, Double> getTotalGenericResources() {
        return new HashMap<String, Double>(this.totalGenericResources);
    }

    public Map<String, Double> getUsedGenericResources() {
        return new HashMap<String, Double>(this.usedGenericResources);
    }

    public SupervisorResources add(WorkerResources wr) {
        this.usedGenericResources = NormalizedResourceRequest.addResourceMap(this.usedGenericResources, wr.get_resources());
        NormalizedResourceRequest.removeNonGenericResources(this.usedGenericResources);
        return new SupervisorResources(this.totalMem, this.totalCpu, this.getTotalGenericResources(), this.usedMem + wr.get_mem_off_heap() + wr.get_mem_on_heap(), this.usedCpu + wr.get_cpu(), this.getUsedGenericResources());
    }

    public SupervisorResources addMem(Double value) {
        return new SupervisorResources(this.totalMem, this.totalCpu, this.getTotalGenericResources(), this.usedMem + value, this.usedCpu, this.getUsedGenericResources());
    }
}

