/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.storm.messaging.netty.ISaslServer;
import org.apache.storm.messaging.netty.IServer;
import org.apache.storm.messaging.netty.KerberosSaslServerHandler;
import org.apache.storm.messaging.netty.SaslStormServerHandler;
import org.apache.storm.messaging.netty.StormServerHandler;
import org.apache.storm.pacemaker.codec.ThriftDecoder;
import org.apache.storm.pacemaker.codec.ThriftEncoder;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelInitializer;
import org.apache.storm.shade.io.netty.channel.ChannelPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftNettyServerCodec
extends ChannelInitializer<Channel> {
    public static final String SASL_HANDLER = "sasl-handler";
    public static final String KERBEROS_HANDLER = "kerberos-handler";
    private static final Logger LOG = LoggerFactory.getLogger(ThriftNettyServerCodec.class);
    private final int thriftMessageMaxSizeBytes;
    private final IServer server;
    private final AuthMethod authMethod;
    private final Map<String, Object> topoConf;

    public ThriftNettyServerCodec(IServer server, Map<String, Object> topoConf, AuthMethod authMethod, int thriftMessageMaxSizeBytes) {
        this.server = server;
        this.authMethod = authMethod;
        this.topoConf = topoConf;
        this.thriftMessageMaxSizeBytes = thriftMessageMaxSizeBytes;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("encoder", (ChannelHandler)new ThriftEncoder());
        pipeline.addLast("decoder", (ChannelHandler)new ThriftDecoder(this.thriftMessageMaxSizeBytes));
        if (this.authMethod == AuthMethod.DIGEST) {
            try {
                LOG.debug("Adding SaslStormServerHandler to pacemaker server pipeline.");
                pipeline.addLast(SASL_HANDLER, (ChannelHandler)new SaslStormServerHandler((ISaslServer)this.server));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (this.authMethod == AuthMethod.KERBEROS) {
            try {
                LOG.debug("Adding KerberosSaslServerHandler to pacemaker server pipeline.");
                ArrayList<String> authorizedUsers = new ArrayList<String>(1);
                authorizedUsers.add((String)this.topoConf.get("nimbus.daemon.user"));
                pipeline.addLast(KERBEROS_HANDLER, (ChannelHandler)new KerberosSaslServerHandler((ISaslServer)this.server, this.topoConf, "PacemakerServer", authorizedUsers));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (this.authMethod == AuthMethod.NONE) {
            LOG.debug("Not authenticating any clients. AuthMethod is NONE");
        }
        pipeline.addLast("handler", (ChannelHandler)new StormServerHandler(this.server));
    }

    public static enum AuthMethod {
        DIGEST,
        KERBEROS,
        NONE;

    }
}

